/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.net.URL;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.analyser.EPSReader;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.messaging.MessageHandler;

public class EPSImage
extends AbstractFopImage {
    private String docName;
    private int[] bbox;
    private byte[] epsImage = null;
    private EPSReader epsReader = null;

    private void init(URL href) {
        this.bbox = new int[4];
        this.bbox[0] = 0;
        this.bbox[1] = 0;
        this.bbox[2] = 0;
        this.bbox[3] = 0;
        this.docName = href.toString();
    }

    public String getDocName() {
        return this.docName;
    }

    public int[] getBBox() {
        return this.bbox;
    }

    public EPSImage(URL href) throws FopImageException {
        super(href);
        this.init(href);
    }

    public EPSImage(URL href, ImageReader imgReader) throws FopImageException {
        super(href, imgReader);
        this.init(href);
        if (imgReader instanceof EPSReader) {
            EPSReader eimgReader;
            this.epsReader = eimgReader = (EPSReader)imgReader;
            this.epsImage = eimgReader.getEpsFile();
            this.m_bitmaps = this.epsImage;
            this.bbox = eimgReader.getBBox();
        }
    }

    protected void loadImage() throws FopImageException {
    }

    public byte[] getEPSImage() throws FopImageException {
        if (this.epsImage == null) {
            MessageHandler.errorln("ERROR LOADING EXTERNAL EPS");
        }
        return this.epsImage;
    }
}

