/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.IconManager;
import ch.fhnw.jbackpack.ProgressDialog;
import ch.fhnw.util.ModalDialogHandler;
import ch.fhnw.util.ProcessExecutor;
import java.awt.Frame;
import java.awt.Window;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecryptionCleanupSwingWorker
extends SwingWorker<Void, Void> {
    private static final Logger LOGGER = Logger.getLogger(DecryptionCleanupSwingWorker.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private final Frame parentFrame;
    private final ProcessExecutor processExecutor;
    private final String tmpPlainPath;
    private final boolean cancelled;
    private final ProgressDialog progressDialog;
    private final ModalDialogHandler dialogHandler;

    public DecryptionCleanupSwingWorker(Frame parentFrame, String tmpPlainPath, boolean cancelled) {
        this.parentFrame = parentFrame;
        this.tmpPlainPath = tmpPlainPath;
        this.cancelled = cancelled;
        this.processExecutor = new ProcessExecutor();
        this.progressDialog = new ProgressDialog((Window)parentFrame, this.processExecutor);
        this.progressDialog.setIcon(IconManager.INFORMATION_ICON);
        this.progressDialog.setMessage(BUNDLE.getString("Deleting_Already_Decrypted_Files"));
        this.progressDialog.setSpecialIcon(null);
        this.progressDialog.setIndeterminate(true);
        this.progressDialog.setCancelButtonVisible(false);
        this.dialogHandler = new ModalDialogHandler(this.progressDialog);
        this.dialogHandler.show();
    }

    @Override
    protected Void doInBackground() {
        int returnValue = this.processExecutor.executeProcess("rm", "-rf", this.tmpPlainPath);
        if (returnValue != 0) {
            LOGGER.log(Level.WARNING, "could not remove {0}", this.tmpPlainPath);
        }
        return null;
    }

    @Override
    protected void done() {
        this.dialogHandler.hide();
        if (!this.cancelled) {
            JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Decryption_Failed"), BUNDLE.getString("Error"), 0);
        }
    }
}

