/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.BackupMainPanel;
import ch.fhnw.jbackpack.IconManager;
import ch.fhnw.jbackpack.ProgressDialog;
import ch.fhnw.util.FileTools;
import ch.fhnw.util.ModalDialogHandler;
import ch.fhnw.util.ProcessExecutor;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptionFinishSwingWorker
extends SwingWorker<Boolean, Void> {
    private static final Logger LOGGER = Logger.getLogger(EncryptionFinishSwingWorker.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private final Frame parentFrame;
    private final BackupMainPanel backupMainPanel;
    private final String destinationPath;
    private final File encfsPlainDir;
    private final String encfsCipherPath;
    private final String password;
    private final String encfsPath;
    private final ModalDialogHandler dialogHandler;
    private final ProcessExecutor processExecutor;

    public EncryptionFinishSwingWorker(Frame parentFrame, BackupMainPanel backupMainPanel, String destinationPath, File encfsPlainDir, String encfsCipherPath, String password) {
        this.parentFrame = parentFrame;
        this.backupMainPanel = backupMainPanel;
        this.destinationPath = destinationPath;
        this.encfsPlainDir = encfsPlainDir;
        this.encfsCipherPath = encfsCipherPath;
        this.password = password;
        this.encfsPath = encfsPlainDir.getPath();
        this.processExecutor = new ProcessExecutor();
        ProgressDialog progressDialog = new ProgressDialog((Window)parentFrame, this.processExecutor);
        progressDialog.setIcon(IconManager.INFORMATION_ICON);
        progressDialog.setMessage(BUNDLE.getString("Removing_Unencrypted_Files"));
        progressDialog.setSpecialIcon(null);
        progressDialog.setIndeterminate(true);
        progressDialog.setCancelButtonVisible(false);
        this.dialogHandler = new ModalDialogHandler(progressDialog);
        this.dialogHandler.show();
    }

    @Override
    protected Boolean doInBackground() {
        int returnValue = this.processExecutor.executeProcess("rm", "-rf", this.destinationPath);
        if (returnValue != 0) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "could not remove original plaintext files in directory {0}", this.destinationPath);
            }
            return false;
        }
        returnValue = this.processExecutor.executeProcess("mv", this.encfsCipherPath, this.destinationPath);
        if (returnValue != 0) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "could not move temporary cipher directory {0} to original directory path {1}", new Object[]{this.encfsCipherPath, this.destinationPath});
            }
            return false;
        }
        try {
            if (FileTools.mountEncFs(this.destinationPath, this.encfsPath, this.password)) {
                return true;
            }
            if (!this.encfsPlainDir.delete()) {
                LOGGER.log(Level.WARNING, "could not delete {0}", this.encfsPlainDir);
            }
            return false;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "re-mounting encrypted directory at original path failed", ex);
            return false;
        }
    }

    @Override
    protected void done() {
        this.dialogHandler.hide();
        try {
            if (((Boolean)this.get()).booleanValue()) {
                this.backupMainPanel.setDestinationEncrypted(true);
                this.backupMainPanel.setEncfsMountPoint(this.encfsPath);
                this.backupMainPanel.checkDestinationCommon();
                JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Destination_Encrypted"), BUNDLE.getString("Information"), 1, IconManager.INFORMATION_ICON);
            } else {
                JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Encryption_Failed"), BUNDLE.getString("Error"), 0);
            }
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }
}

