/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.ProgressDialog;
import ch.fhnw.util.ModalDialogHandler;
import ch.fhnw.util.ProcessExecutor;
import java.awt.Window;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerCheckSwingWorker
extends SwingWorker<Boolean, Object> {
    protected final String password;
    private static final Logger LOGGER = Logger.getLogger(ServerCheckSwingWorker.class.getName());
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private static final byte WRONG_PASSWORD = 42;
    private final Window parent;
    private final ProgressDialog progressDialog;
    private final ModalDialogHandler dialogHandler;
    private final ProcessExecutor processExecutor;
    private final String user;
    private final String host;
    private final String warningMessageKey;
    private boolean wrongPassword;

    public ServerCheckSwingWorker(Window parent, String user, String host, String password, String warningMessageKey) {
        this.parent = parent;
        this.user = user;
        this.host = host;
        this.password = password;
        this.warningMessageKey = warningMessageKey;
        this.processExecutor = new ProcessExecutor();
        this.progressDialog = new ProgressDialog(parent, this.processExecutor);
        String message = BUNDLE.getString("Remote_Checking_For_RdiffBackup");
        message = MessageFormat.format(message, host);
        this.progressDialog.setMessage(message);
        this.progressDialog.setCancelButtonVisible(false);
        this.dialogHandler = new ModalDialogHandler(this.progressDialog);
        this.dialogHandler.show();
    }

    protected abstract void runOperation(boolean var1);

    @Override
    protected Boolean doInBackground() {
        String checkScript = "#!/usr/bin/expect -f" + LINE_SEPARATOR + "set password [lindex $argv 0]" + LINE_SEPARATOR + "spawn -ignore HUP rdiff-backup --test-server " + this.user + '@' + this.host + "::/" + LINE_SEPARATOR + "while 1 {" + LINE_SEPARATOR + "    expect {" + LINE_SEPARATOR + "        eof {" + LINE_SEPARATOR + "            break" + LINE_SEPARATOR + "        }" + LINE_SEPARATOR + "        \"Permission denied*\" {" + LINE_SEPARATOR + "            exit " + 42 + LINE_SEPARATOR + "        }" + LINE_SEPARATOR + "        \"continue connecting*\" {" + LINE_SEPARATOR + "            send \"yes\r\"" + LINE_SEPARATOR + "        }" + LINE_SEPARATOR + "        \"" + this.user + '@' + this.host + "'s password:\" {" + LINE_SEPARATOR + "            send \"$password\r\"" + LINE_SEPARATOR + "        }" + LINE_SEPARATOR + "    }" + LINE_SEPARATOR + "}" + LINE_SEPARATOR + "set ret [lindex [wait] 3]" + LINE_SEPARATOR + "puts \"return value: $ret\"" + LINE_SEPARATOR + "exit $ret";
        Logger logger = Logger.getLogger(ProcessExecutor.class.getName());
        Level level = logger.getLevel();
        logger.setLevel(Level.OFF);
        int returnValue = -1;
        try {
            returnValue = this.processExecutor.executeScript(true, true, checkScript, this.password == null ? "" : this.password);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        logger.setLevel(level);
        this.wrongPassword = 42 == returnValue;
        return returnValue == 0;
    }

    @Override
    protected void done() {
        this.dialogHandler.hide();
        try {
            if (((Boolean)this.get()).booleanValue()) {
                this.runOperation(true);
            } else {
                if (this.wrongPassword) {
                    JOptionPane.showMessageDialog(this.parent, BUNDLE.getString("Error_Wrong_Password"), BUNDLE.getString("Error"), 0);
                    return;
                }
                String warningMessage = BUNDLE.getString(this.warningMessageKey);
                int returnValue = JOptionPane.showOptionDialog(this.parent, warningMessage = MessageFormat.format(warningMessage, this.host), BUNDLE.getString("Warning"), 2, 2, null, null, null);
                if (returnValue == 0) {
                    this.runOperation(false);
                }
            }
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }
}

