/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.net.URL;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.DefaultLaunchHandler;
import net.sourceforge.jnlp.IconDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.JNLPSplashScreen;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.util.BasicExceptionDialog;

public class GuiLaunchHandler
implements LaunchHandler {
    private JNLPSplashScreen splashScreen = null;
    private UpdatePolicy policy = UpdatePolicy.ALWAYS;

    @Override
    public void launchCompleted(ApplicationInstance application) {
    }

    @Override
    public void launchError(final LaunchException exception) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicExceptionDialog.show(exception);
            }
        });
    }

    @Override
    public void launchStarting(ApplicationInstance application) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (GuiLaunchHandler.this.splashScreen != null) {
                    if (GuiLaunchHandler.this.splashScreen.isSplashScreenValid()) {
                        GuiLaunchHandler.this.splashScreen.setVisible(false);
                    }
                    GuiLaunchHandler.this.splashScreen.dispose();
                }
            }
        });
    }

    @Override
    public void launchInitialized(final JNLPFile file) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int preferredWidth = 500;
                int preferredHeight = 400;
                URL splashImageURL = file.getInformation().getIconLocation(IconDesc.SPLASH, 500, 400);
                if (splashImageURL != null) {
                    ResourceTracker resourceTracker = new ResourceTracker(true);
                    resourceTracker.addResource(splashImageURL, file.getFileVersion(), null, GuiLaunchHandler.this.policy);
                    GuiLaunchHandler.this.splashScreen = new JNLPSplashScreen(resourceTracker, null, null);
                    GuiLaunchHandler.this.splashScreen.setSplashImageURL(splashImageURL);
                    if (GuiLaunchHandler.this.splashScreen.isSplashScreenValid()) {
                        GuiLaunchHandler.this.splashScreen.setVisible(true);
                    }
                }
            }
        });
    }

    @Override
    public boolean launchWarning(LaunchException warning) {
        DefaultLaunchHandler.printMessage(warning);
        return true;
    }

    @Override
    public boolean validationError(LaunchException security) {
        DefaultLaunchHandler.printMessage(security);
        return true;
    }
}

