/*
 * Decompiled with CFR 0.152.
 */
package hr.fjagic.jdosage2;

import freemarker.log.Logger;
import hr.fjagic.jdosage2.Configuration;
import hr.fjagic.jdosage2.WebcomicManager;
import hr.fjagic.jdosage2.webcomic.Webcomic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class JDosage2CLI {
    private static final String CLI_LIST = "list";
    private static final String CLI_DOWNLOAD = "download";
    private static final String CLI_IGNORE_MISSING = "ignoremissing";
    private static final String CLI_IGNORE_EXISTING = "ignoreexisting";

    public static void main(String[] args) throws ClassNotFoundException {
        Logger.selectLoggerLibrary((int)5);
        OptionBuilder.withLongOpt(CLI_LIST);
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withArgName("webcomic...");
        OptionBuilder.withDescription("Lists webcomics with definition files matching wildcard expression");
        Option download = OptionBuilder.create('l');
        OptionBuilder.withLongOpt(CLI_DOWNLOAD);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName("webcomic...");
        OptionBuilder.withDescription("Downloads webcomics with definition files matching wildcard expression");
        Option list = OptionBuilder.create('d');
        OptionBuilder.withLongOpt(CLI_IGNORE_EXISTING);
        OptionBuilder.withDescription("Don't stop the download when existing comic is found");
        Option ignoreExisting = OptionBuilder.create('e');
        OptionBuilder.withLongOpt(CLI_IGNORE_MISSING);
        OptionBuilder.withDescription("Don't stop the download when no comics are found on a page");
        Option ignoreMissing = OptionBuilder.create('m');
        Options options = new Options();
        OptionGroup group = new OptionGroup();
        group.addOption(list);
        group.addOption(download);
        group.setRequired(true);
        options.addOptionGroup(group);
        options.addOption(ignoreExisting);
        options.addOption(ignoreMissing);
        try {
            CommandLine commandLine = new BasicParser().parse(options, args);
            Configuration config = Configuration.getInstance();
            WebcomicManager wcm = new WebcomicManager(config);
            if (commandLine.hasOption(CLI_LIST)) {
                String[] webcomicExps = commandLine.getOptionValues(CLI_LIST);
                if (webcomicExps == null || webcomicExps.length == 0) {
                    webcomicExps = new String[]{"*", "*/*"};
                }
                Collection<Webcomic> webcomics = wcm.getWebcomics(webcomicExps);
                ArrayList<Webcomic> sortedWebcomics = new ArrayList<Webcomic>(webcomics);
                Collections.sort(sortedWebcomics, new Comparator<Webcomic>(){

                    @Override
                    public int compare(Webcomic o1, Webcomic o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (Webcomic webcomic : sortedWebcomics) {
                    System.out.println(webcomic.getName());
                }
            } else if (commandLine.hasOption(CLI_DOWNLOAD)) {
                if (commandLine.hasOption(CLI_IGNORE_EXISTING)) {
                    config.setIgnoreExistingComics(true);
                }
                if (commandLine.hasOption(CLI_IGNORE_MISSING)) {
                    config.setIgnoreMissingComics(true);
                }
                String[] webcomicExps = commandLine.getOptionValues(CLI_DOWNLOAD);
                Collection<Webcomic> webcomics = wcm.getWebcomics(webcomicExps);
                wcm.downloadComics(webcomics);
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            new HelpFormatter().printHelp("JDosage2 webcomic downloader", options);
        }
    }
}

