/*
	This file is part of jrisk.

	jrisk is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	jrisk is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with jrisk; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * Created on 15-feb-2005 by Alessio Treglia
 * Copyright  2005 Alessio Treglia
 */

import java.io.*;

/**
 * Modella un comando che consente al giocatore di spostare
 * un numero di armate da un territorio all'altro.
 *
 * @author Alessio Treglia
 * @version 1.0.0
 */
public class ComandoSposta extends Comando {
    /** Contiene il nome del comando */
    private final String nomeComando = "sposta";
    /** Territorio dal quale prendere le armate */
    private String partenza;
    /** Territorio sul quale mettere le armate */
    private String destinazione;
    
    /**
     * Inizializza il comando sposta armate
     * 
     * @param da territorio dal quale spostare le armate
     * @param a territorio sul quale spostare le armate
     */
    public ComandoSposta(String da, String a) {
        this.partenza = da;
        this.destinazione = a;
    }
    /* (non-Javadoc)
     * @see Comando#getNomeComando()
     */   
    public String getNomeComando() { return this.nomeComando; }

    /* (non-Javadoc)
     * @see Comando#esegui(Giocatore, java.util.Map)
     */
    public boolean esegui(Giocatore giocatore, Tabellone planisfero)
    	throws IOException {
        Giocatore g1, g2;
        Territorio da, a;
        int n;
        
        /*
         * Controllo che il nome degli stati sia giusto
         */
        if(!ElencoTerritoriContinenti.territorioValido(partenza) ||
                !ElencoTerritoriContinenti.territorioValido(destinazione))
            return new ComandoNonValido().esegui(giocatore, planisfero);
        
        g1 = (Giocatore) planisfero.getGiocatoreAt(partenza);
        g2 = (Giocatore) planisfero.getGiocatoreAt(destinazione);
        /*
         * Si accerta che il giocatore sposti le armate sui propri
         * territori
         */
        if(giocatore == g1 && giocatore == g2) {
            da = giocatore.getTerritorio(partenza);
            a = giocatore.getTerritorio(destinazione);
            /*
             * Si accerta che il territorio di partenza sia diverso
             * da quello di destinazione
             */
            /*
             * TODO: deve accertarsi che siano confinanti
             */
            // if(da != a)
            if(da.confinaCon(a)) {
                giocatore.schermo.stampa("Quante armate vuoi spostare da " + da.getNome() + " a " + a.getNome() + "?");
                n = -1;
                while(n == -1) {
                    /* Passa il turno */
                    n = giocatore.parser.getInt();
                    if(n == 0)
                        return false;
                    if(!da.muovi(n,a)) {
                        giocatore.schermo.stampa("Digita un numero corretto, 0 per annullare: ");
                        n = -1;
                    } else {
                        // TODO: NON FA LO SPOSTAMENTO
                        g1.schermo.stampaln("Spostamento da " + partenza + " a " + destinazione + 
                                " effettuato.");
                        return true;
                    }
                }                
            } else {
                g1.schermo.stampa("Non puoi spostare armate verso lo stesso " +
                        "territorio!");
            }
        } else {
            g1.schermo.stampa("Puoi spostare le armate solo fra territori confinanti "+
                    "e di tua appartenenza.");
        }
        return false;
    }
}
