/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Gioco {
    protected static final int MIN_GIOCATORI = 2;
    protected static final int MAX_GIOCATORI = 6;
    protected static final int[] ARMATE_GIOCATORI = new int[]{40, 35, 30, 25, 20};
    protected static final String[] COLORI = new String[]{"rosso", "nero", "verde", "blu", "viola", "giallo"};
    protected List giocatori;
    protected Tabellone planisfero;
    protected static Parser parser;
    protected static Display schermo;

    public Gioco() {
        schermo = new Display();
        parser = new Parser();
        this.giocatori = new LinkedList();
        this.planisfero = new Tabellone();
    }

    protected void eliminaGiocatoriSconfitti() {
        Iterator it = this.giocatori.iterator();
        while (it.hasNext()) {
            Giocatore corrente = (Giocatore)it.next();
            if (corrente.getTerritori().size() == 0) {
                // empty if block
            }
            this.giocatori.remove(corrente);
        }
    }

    protected Giocatore finePartita() {
        if (this.giocatori.size() == 1) {
            Iterator it = this.giocatori.iterator();
            return (Giocatore)it.next();
        }
        return null;
    }

    protected void assegnaTerritori() {
        DistributoreTerritori distributoreTerritori = new DistributoreTerritori(this.planisfero);
        distributoreTerritori.assegnaCasualmente(this.giocatori);
        distributoreTerritori.impostaConfini(this.giocatori);
    }

    protected void assegnaArmateIniziali() throws IOException {
        Territorio t;
        Giocatore g;
        int n = this.giocatori.size();
        int armate = ARMATE_GIOCATORI[n - 2];
        Iterator it = this.giocatori.iterator();
        while (it.hasNext()) {
            g = (Giocatore)it.next();
            Set territori = g.getTerritori();
            Iterator jt = territori.iterator();
            while (jt.hasNext()) {
                t = (Territorio)jt.next();
                t.setArmate(Territorio.getMinimoArmate());
            }
        }
        it = this.giocatori.iterator();
        while (it.hasNext()) {
            g = (Giocatore)it.next();
            int armateGiocatore = armate - g.getTerritori().size();
            g.schermo.stampaln(g.toString());
            g.schermo.stampaln(String.valueOf(g.getColore()) + " ha " + armateGiocatore + " armate da posizionare. ");
            String territorio = null;
            int i = 0;
            while (i < armateGiocatore) {
                if (territorio == null) {
                    g.schermo.stampa("Digita dove posizionare la " + (i + 1) + " armata: ");
                    territorio = g.parser.getParola();
                    if (ElencoTerritoriContinenti.territorioValido(territorio)) {
                        t = g.getTerritorio(territorio);
                        if (t != null) {
                            t.setArmate(t.getArmate() + 1);
                            g.schermo.stampaln(String.valueOf(t.getNome()) + " ha " + t.getArmate() + " armate.");
                            territorio = null;
                        } else {
                            --i;
                            territorio = null;
                        }
                    } else {
                        --i;
                        territorio = null;
                    }
                }
                ++i;
            }
        }
    }

    protected void assegnaArmate(Giocatore g) throws IOException {
        int armate = DistributoreArmate.daiArmate(g);
        g.schermo.stampaln(String.valueOf(g.getColore()) + " deve posizionare " + armate + " armate.");
        int i = 0;
        while (i < armate) {
            String territorio = null;
            if (territorio == null) {
                g.schermo.stampa("Digita dove posizionare la " + (i + 1) + " armata: ");
                territorio = g.parser.getParola();
                if (ElencoTerritoriContinenti.territorioValido(territorio)) {
                    Territorio t = g.getTerritorio(territorio);
                    if (t != null) {
                        t.setArmate(t.getArmate() + 1);
                        g.schermo.stampaln(String.valueOf(t.getNome()) + " ha " + t.getArmate());
                        territorio = null;
                    } else {
                        --i;
                        territorio = null;
                    }
                } else {
                    --i;
                    territorio = null;
                }
            } else {
                --i;
                territorio = null;
            }
            ++i;
        }
    }

    protected void impostaGiocatori() throws IOException {
        int n = 0;
        schermo.stampa("Quanti sono i giocatori (2 - 6): ");
        n = parser.getInt();
        while (n < 2 || n > 6) {
            schermo.stampa("\nNumero errato. (2 - 6): ");
            n = parser.getInt();
        }
        int i = 0;
        while (i < n) {
            this.giocatori.add(new Giocatore(COLORI[i]));
            ++i;
        }
    }

    public void run() throws IOException {
        Giocatore toccaA;
        Giocatore vincitore = null;
        this.impostaGiocatori();
        this.assegnaTerritori();
        Iterator it = this.giocatori.iterator();
        while (it.hasNext()) {
            toccaA = (Giocatore)it.next();
            toccaA.schermo.stampaln(toccaA.toString());
        }
        this.assegnaArmateIniziali();
        while (vincitore == null) {
            it = this.giocatori.iterator();
            Giocatore.aggiornaTurni();
            while (it.hasNext()) {
                boolean passaTurno = false;
                toccaA = (Giocatore)it.next();
                toccaA.schermo.stampaln(toccaA.toString());
                this.assegnaArmate(toccaA);
                while (!passaTurno) {
                    Comando comando = toccaA.parser.getComando();
                    if (comando.getNomeComando() == "esci") {
                        toccaA.schermo.stampaln("Sei sicuro di voler uscire? ");
                        if (toccaA.parser.getParola().equals("si")) {
                            return;
                        }
                    }
                    passaTurno = comando.esegui(toccaA, this.planisfero);
                }
                if (toccaA.eliminato()) {
                    it.remove();
                    continue;
                }
                if (toccaA.haVinto()) {
                    vincitore = toccaA;
                    continue;
                }
                if (!DistributoreCarte.daiCarta(toccaA)) continue;
                schermo.stampaln(String.valueOf(toccaA.getColore()) + " pesca una carta...");
            }
        }
        schermo.stampa(String.valueOf(vincitore.getColore()) + " ha vinto in " + Giocatore.getTurnoCorrente() + " turni!");
    }

    public List getGiocatori() {
        return this.giocatori;
    }

    public static void main(String[] args) {
        Gioco jrisk = new Gioco();
        try {
            jrisk.run();
        }
        catch (IOException e) {
            schermo.stampaln("Errore fatale!");
        }
    }
}

