<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_acl_new extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;
/**
* @var integer id for new ace
*/
public $newid = 0;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_redirect(-1,XF::link('acp_overview'));
  return true;
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $id = XF::sanitize_var(XF::ifset($input,'id',''),'action');
  $this->gpc = array('id'=>$id);
  return true;
  }

  /**
  * create a new access control entry
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $schk = XF::sql_query("SELECT COUNT(a_id) AS action_available FROM ".XF::tbl('acl')." WHERE a_action = :id",array(
    'id'=>array($this->gpc['id'],'str')),__METHOD__,__LINE__);
    $data = $schk->fetchObject();
      if ( !is_object($data) || (int)$data->action_available === 0 )
      $this->error = '{:no_valid_id}';
    $schk->closeCursor();

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('acl'=>'w')) )
        throw new XFE('unable to begin database transaction');
      XF::sql_query("INSERT INTO ".XF::tbl('acl')." (a_action,a_use_group) VALUES (:action,'0')",array(
      'action'=>array($this->gpc['id'],'str')),__METHOD__,__LINE__);
      $this->newid = XF::sql_lastId('acl.a_id');
        if ( !$this->newid )
        throw new XFE('new ACE could not be inserted');
      XF::logger('info','id',$this->newid,'action',$this->gpc['id'],'as_user','yes');
      XF::sql_transaction('commit');
      $this->success = true;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_acp_acl_new($input){
  $a = new XFAction_acp_acl_new();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $b = $a->get_GPC();
  $a->execute();
    if ( $a->get_success() ){
    $i = '      <div class="xf_right">
          <label><input type="radio" name="f_'.$a->newid.'_allow" class="xf_input_radio" value="1" checked="checked" /> '.XFUI::i18n('allow').'&nbsp;</label>
          <label><input type="radio" name="f_'.$a->newid.'_allow" class="xf_input_radio" value="0" /> '.XFUI::i18n('deny').'&nbsp;</label>
          </div>
          <input type="hidden" id="f_ace_key_'.$a->newid.'" name="f_'.$a->newid.'_key" value="'.$a->newid.'" />
          <img src="'.XFUI::image('icon_delete').'" alt="delete (not allowed)" class="xf_shaded" />
          '.XFUI::i18n('ace_to_user').'
          <span id="f_ace_user_name_'.$a->newid.'">&nbsp;</span>
          <a href="#open_user_selection" id="f_ace_link_'.$a->newid.'" onclick="window.open(\''.XF::link('help',array('segment'=>'user_aa','id'=>$a->newid)).'\',\'xfus\',\'width=400,height=300\');">'.XFUI::i18n('select_user').'</a>
        <br clear="all" />
    ';
    XFUI::$ajax_response->create('xf__ace','li','f_ace_'.$a->newid);
    XFUI::$ajax_response->assign('f_ace_'.$a->newid,'className','xf_half_width xf_highlight');
    XFUI::$ajax_response->assign('f_ace_'.$a->newid,'innerHTML',$i);
    return xfaf_success('','{:new_ace_successful}');
    }
    else
    return xfaf_failure($a->get_error());
  }

?>