<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_ucp_bookmark extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;
public $sucmsg = '';
public $sucid = '';

// TDOD: [idle] init() hmm, automatically add new topics having a 'enlist as request' prefix to bookmarks?

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','ucp');
  XFUI::load_lang_res('','topic');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  $bookmarks = array();
  $pp = XFUI::get_post_prefix_list();
  $sbmk = XF::sql_query("SELECT p_id,p_topic_id,p_time,p_pp_id,p_subject FROM ".XF::tbl('user_bookmark')."
  LEFT JOIN ".XF::tbl('post_meta')." ON ".XF::tbl('post_meta').".p_id = ".XF::tbl('user_bookmark').".uk_p_id
  WHERE uk_u_id = :id",array('id'=>array(XF::vault_query('current_user_id'),'int')),__METHOD__,__LINE__);
    while ( $r = $sbmk->fetchObject() ){
    $r->p_id = intval($r->p_id);
    $subject = ( isset($pp[$r->p_pp_id]) ) ? '['.$pp[$r->p_pp_id]['pp_name'].'] '.$r->p_subject : $r->p_subject;
    $bookmarks[] = array(
    'p_id'=>$r->p_id,
    'p_topic_id'=>intval($r->p_topic_id),
    'p_subject'=>$subject,
    'p_time'=>intval($r->p_time)
    );
    }
  $sbmk->closeCursor();

  XF::tan('ucp_bookmark');
  XFUI::ajax_init();
  XFUI::html_head('{:my_bookmarks}');
  XF::$tpl->clear_cache('ucp_bookmark.tpl');
  XF::$tpl->assign('bookmark_data',$bookmarks);
  XF::$tpl->display('ucp_bookmark.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $id = XF::sanitize_var(XF::ifset($input,'id',0),'int');
  $this->gpc = array('id'=>$id);
  return true;
  }

  /**
  * manage a user bookmark
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $susr = XF::sql_query("SELECT COUNT(uk_p_id) AS is_bookmarked FROM ".XF::tbl('user_bookmark')."
    WHERE uk_u_id = :userid AND uk_p_id = :postid",
    array('userid'=>array(XF::vault_query('current_user_id'),'int'),
    'postid'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
    $bookmarkdata = $susr->fetchObject();
    $susr->closeCursor();

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('user_bookmark'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $op = ( (int)$bookmarkdata->is_bookmarked === 0 ) ? '+' : '-';

        if ( $op === '+' ){
        $i = XF::sql_query("INSERT INTO ".XF::tbl('user_bookmark')." (uk_u_id,uk_p_id) VALUES (:userid,:postid)",
        array('userid'=>array(XF::vault_query('current_user_id'),'int'),
        'postid'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
          if ( !$i )
          throw new XFE('could not add bookmark for posting "'.$this->gpc['id'].'"');
          if ( isset($_SESSION['xf_bookmark']) ){
            if ( !in_array($this->gpc['id'],$_SESSION['xf_bookmark'],true) )
            $_SESSION['xf_bookmark'][] = $this->gpc['id'];
          }
        }
        elseif ( $op === '-' ){
        $d = XF::sql_query("DELETE FROM ".XF::tbl('user_bookmark')." WHERE uk_p_id = :postid AND uk_u_id = :userid",
        array('userid'=>array(XF::vault_query('current_user_id'),'int'),
        'postid'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
          if ( !$d )
          throw new XFE('could not delete bookmark for posting "'.$this->gpc['id'].'"');
          if ( isset($_SESSION['xf_bookmark']) ){
            foreach ( $_SESSION['xf_bookmark'] as $k=>$v ){
              if ( $this->gpc['id'] === $v )
              unset($_SESSION['xf_bookmark'][$k]);
            }
          }
        }

      XF::logger('info','postid',$this->gpc['id'],'option',$op);
      XF::sql_transaction('commit');
      $this->success = true;
      $this->sucmsg = ( $op === '+' ) ? '{:bookmark_has_been_added}' : '{:bookmark_has_been_removed}';
      $this->sucid = $op;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_ucp_bookmark($input){
  $a = new XFAction_ucp_bookmark();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $b = $a->get_GPC();
  $a->execute();
    if ( $a->get_success() ){
      if ( $a->sucid === '-' )
      XFUI::$ajax_response->script('xf_visibility(\'xf__bookmark_'.intval($b['id']).'\',\'none\');');
    $c = ( $a->sucid === '-' ) ? XFUI::i18n('add_bookmark') : XFUI::i18n('remove_bookmark');
    XFUI::$ajax_response->assign('xf_post_bookmark_'.$b['id'],'innerHTML',$c);
    return xfaf_success('',$a->sucmsg);
    }
    else
    return xfaf_failure($a->get_error());
  }

?>