<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_pp_new extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XF::tan('acp_pp_new');
  XFUI::ajax_init();
  XFUI::html_head('{:post_prefix}');
  //XF::$tpl->clear_cache('form_acp_pp_new.tpl');
  XF::$tpl->display('form_acp_pp_new.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $name = XF::sanitize_var(XF::ifset($input,'f_name',''),'str','stripspaces,length=4-64');
  $acl = XF::sanitize_var(XF::ifset($input,'f_acl',''),'str','okifempty,length=0-255,stripspaces');
  $lar = XF::sanitize_var(XF::ifset($input,'f_lar',0),'booli');
  $this->gpc = array('f_name'=>$name,'f_acl'=>$acl,'f_lar'=>$lar);
  $this->markgpc = array('f_name','f_acl');
  return true;
  }

  /**
  * create a new post prefix
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('post_prefix'=>'w')) )
        throw new XFE('unable to begin database transaction');
      XF::sql_query("INSERT INTO ".XF::tbl('post_prefix')." (pp_name,pp_preset_acl,pp_list_as_request) VALUES (:name,:acl,:lar)",array(
      'name'=>array($this->gpc['f_name'],'str'),
      'acl'=>array(implode(',',array_unique(explode(',',$this->gpc['f_acl']))),'str'),
      'lar'=>array($this->gpc['f_lar'],'int')),__METHOD__,__LINE__);
      $newppid = XF::sql_lastId('post_prefix.pp_id');
        if ( !$newppid )
        throw new XFE('cannot insert new post prefix');
      XF::logger('info','new_id',$newppid);
      XF::sql_transaction('commit');
      XFCache::purge('simple','subject_prefix');
      $this->success = true;
      }
    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_acp_pp_new($input){
  $a = new XFAction_acp_pp_new();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success(XF::link('acp_pp_list','',false),'{:new_prefix_successful}');
    else
    return xfaf_failure($a->get_error());
  }

?>