<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_overview extends XFAction {
const USE_TAN = false;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  XFUI::load_lang_res('','acpacl');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  $new_version_available = false;
  $security_is_affected = false;
  $updchk = XF::sanitize_var(XF::ifset('GET','updchk',0),'booli');
  $this->gpc = array('update_check'=>$updchk);
  unset($updchk);

    if ( $this->gpc['update_check'] === 1 ){
    $reply = '';
    $host = 'freesoftware.net23.net';
    //$host = 'testing-php5.home.net';
    $request = "GET /larusboard/updater_info_v1.xml HTTP/1.0\r\nHost: $host\r\nConnection: close\r\n\r\n";
    $sock = fsockopen($host,80);
      if ( $sock ){
      fputs($sock,$request);
        while ( !feof($sock) )
        $reply .= fread($sock,2048);
      fclose($sock);
      $data = self::update_check($reply);
        if ( is_string($data) )
        $new_version_available = $data;
        else{
        $new_version_available = ( is_array($data) && sizeof($data) === 2 )
        ? sprintf(XFUI::i18n('new_forum_software_version_available'),$data['uri'],$data['version'])
        : XFUI::i18n('using_recent_forum_software_version');
          if ( isset($data['advisory']) && $data['advisory'] )
          $security_is_affected = sprintf(XFUI::i18n('security_advisory_issued_for_your_version'),$data['sa_uri'],$data['sa_message']);
        }
      }
    unset($host,$sock,$request,$reply,$data);
    }

  $ucfg = array('main_enable','main_version');
  $rcfg = XF::get_cfg('*');
  $cfg = array();
    foreach ( $rcfg as $k=>$v ){
      if ( in_array($k,$ucfg,true) )
      $cfg[$k] = $v;
    }
  unset($rcfg,$ucfg);

  $stsk = XF::sql_query("SELECT * FROM ".XF::tbl('config_task')."
  WHERE ct_active = true ORDER BY ct_time_last DESC LIMIT 1 OFFSET 0",'',__METHOD__,__LINE__);
  $task = $stsk->fetchObject();
  $task = ( is_object($task) ) ? (array)$task : array();
    if ( isset($task['ct_time_last']) )
    $task['next_run'] = intval($task['ct_time_last']+$task['ct_time_interval']);
  $stsk->closeCursor();

    if ( XF::get_cfg('log_enable') ){
    $data = array();
    $group = XF::get_group('*');
    $slog = XF::sql_query("SELECT * FROM ".XF::tbl('log')." WHERE l_index_month = :month AND l_index_year = :year
    ORDER BY l_time DESC LIMIT 15 OFFSET 0",array(
    'month'=>array(gmdate('m'),'int'),
    'year'=>array(gmdate('Y'),'int')),__METHOD__,__LINE__);
      while ( $r = $slog->fetchObject() ){
      $action = explode(',',$r->l_action);
      $user = XF::get_user($r->l_u_id);
      $r->l_ip = XFUI::ip_transform($r->l_ip);
      $r->u_name = $user['u_name'];
      $r->g_name = $group[$user['u_group']]['g_name'];
      $r->g_color = $group[$user['u_group']]['g_color'];
      $r->level_str = 'log_level_'.$r->l_level;
      $r->method = $action[0];
      $r->action = $action[1];
      $r->action_str = 'acl_seg_'.$r->action;
      XF::logger_parse_message($r);
      unset($r->l_action);
      $data[] = (array)$r;
      }
    $slog->closeCursor();
    XF::$tpl->clear_cache('acp_log_results.tpl');
    XF::$tpl->assign('log_listing',$data);
    $log = trim(XF::$tpl->fetch('acp_log_results.tpl'));
    XF::reset_tpl();
    unset($data,$group);
    }
    else
    $log = false;

    if ( !XF::$tpl->is_cached('acp_overview_statistic.tpl') ){
    $stat = array();
    $today = gmmktime(0,0,0,gmdate('m'),gmdate('d'),gmdate('y'));
    $susr = XF::sql_query("SELECT COUNT(u_id) AS user_count FROM ".XF::tbl('user')." WHERE u_time_registration > :today",array(
    'today'=>array($today,'int')),__METHOD__,__LINE__);
    $r = $susr->fetchObject();
    $stat['user_registered_today'] = ( is_object($r) ) ? intval($r->user_count) : 0;
    $susr->closeCursor();
    $susr = XF::sql_query("SELECT COUNT(ur_class) AS request_count FROM ".XF::tbl('user_request')."
    WHERE ur_class IN ('ACTIVATE_ACCOUNT','ACTIVATE_PASSWORD')",'',__METHOD__,__LINE__);
    $r = $susr->fetchObject();
    $stat['user_request_total'] = ( is_object($r) ) ? intval($r->request_count) : 0;
    $susr->closeCursor();
    $susr = XF::sql_query("SELECT COUNT(u_id) AS user_count,u_active FROM ".XF::tbl('user')." GROUP BY u_active",__METHOD__,__LINE__);
      while ( $r = $susr->fetchObject() ){
        if ( (bool)$r->u_active )
        $stat['user_account_enabled'] = intval($r->user_count);
        else
        $stat['user_account_disabled'] = intval($r->user_count);
      }
    $stat['user_total'] = ( isset($stat['user_account_enabled']) && isset($stat['user_account_disabled']) )
    ? intval($stat['user_account_enabled']+$stat['user_account_disabled']) : 0;
    $susr->closeCursor();
    $spst = XF::sql_query("SELECT COUNT(p_id) AS post_count,p_approved FROM ".XF::tbl('post_meta')." GROUP BY p_approved",'',__METHOD__,__LINE__);
      while ( $r = $spst->fetchObject() ){
        if ( (bool)$r->p_approved )
        $stat['post_visible'] = intval($r->post_count);
        else
        $stat['post_hidden'] = intval($r->post_count);
      }
      if ( !isset($stat['post_hidden']) )
      $stat['post_hidden'] = 0;
    $stat['post_total'] = ( isset($stat['post_visible']) && isset($stat['post_hidden']) )
    ? intval($stat['post_visible']+$stat['post_hidden']) : 0;
    $spst->closeCursor();
    XF::$tpl->cache_lifetime = 1800;
    XF::$tpl->assign('statistic_data',$stat);
    unset($today,$r);
    }
  $stat = XF::$tpl->fetch('acp_overview_statistic.tpl');
  XF::reset_tpl();

    if ( !XF::$tpl->is_cached('acp_overview_request.tpl') ){
    $cg = XF::vault_query('current_group_id');
    $pp = XFUI::get_post_prefix_list(true);
    $group = XF::get_group('*');
    $lpr = array();
      foreach ( $pp as $k=>$v ){
        if ( !$v['pp_list_as_request'] )
        unset($pp[$k]);
      }
    $ppi = array_keys($pp);
    $ru = ( $group[$cg]['g_read_unapproved'] ) ? '' : 'AND p_approved = true';
    $slpr = XF::sql_query("SELECT p_id,p_u_id,p_pp_id,p_time,p_subject FROM ".XF::tbl('post_meta')."
    WHERE p_pp_id IN (".implode(',',$ppi).") AND p_closed = false $ru ORDER BY p_weight DESC, p_time DESC",'',__METHOD__,__LINE__);
      while ( $r = $slpr->fetchObject() ){
      $u = XF::get_user($r->p_u_id);
      $r->p_subject = '['.$pp[$r->p_pp_id]['pp_name'].'] '.$r->p_subject;
      $r->u_name = $u['u_name'];
      $r->g_name = $group[$u['u_group']]['g_name'];
      $r->g_color = $group[$u['u_group']]['g_color'];
      $lpr[] = (array)$r;
      }
    $slpr->closeCursor();
    XF::$tpl->cache_lifetime = 600;
    XF::$tpl->assign('pending_request',$lpr);
    unset($cg,$pp,$group,$k,$v,$r,$ppi,$ru,$u,$lpr);
    }
  $pr = XF::$tpl->fetch('acp_overview_request.tpl');
  XF::reset_tpl();

  $has = XF::vault_query('root_path').'/lang/'.XF::vault_query('current_language').'/support.txt';
  $has = XF::file_handler($has,'','read,local,noroot');
  $gat = XFCache::get('simple','announcement');
  XFUI::html_head('{:acp_overview}');
  XF::$tpl->clear_cache('acp_overview.tpl');
  XF::$tpl->assign('global_announcement_text',(is_array($gat)&&isset($gat[0])&&!empty($gat[0]))?$gat[0]:'');
  XF::$tpl->assign('database_too_old',(XF::DATABASE_VERSION > XF::get_cfg('main_version'))?true:false);
  XF::$tpl->assign('new_version',$new_version_available);
  XF::$tpl->assign('security_is_affected',$security_is_affected);
  XF::$tpl->assign('version',array('software'=>XF::VERSION,'php'=>PHP_VERSION,'database'=>__XF_SQL_ENGINE.' '.XF::$sql->getAttribute(PDO::ATTR_SERVER_VERSION)));
  XF::$tpl->assign('has_text',$has);
  XF::$tpl->assign('statistic',$stat);
  XF::$tpl->assign('pending_request',$pr);
  XF::$tpl->assign('config_vars',$cfg);
  XF::$tpl->assign('task',$task);
  XF::$tpl->assign('log',$log);
  XF::$tpl->display('acp_overview.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * @since 1.0.0
  */
  protected function ajax($input){}

  /**
  * executives overview (starts in run() directly)
  * @since 1.0.0
  */
  public function execute(){}

  /**
  * parse returned xml for recent version notifications
  * @param string $a http reply
  * @return mixed
  * @since 1.0.0
  */
  static protected function update_check($a){
  $o = array();
  $a = explode("\r\n\r\n",$a);
    if ( sizeof($a) !== 2 )
    return 'ERROR_INVALID_CONTENT';
  preg_match_all('/^HTTP\/1\.[01]{1} \d{3} [a-z ]+/im',$a[0],$rc);
  $rc = ( isset($rc[0][0]) ) ? trim($rc[0][0]) : '';
    if ( !strpos($rc,'OK') ) // NOTE: i bet some servers do not return '200 OK'...
    return 'ERROR_'.strtoupper(preg_replace('/[^a-z0-9_]+/i','_',$rc));
    if ( !preg_match('/Content-Type: (application|text)\/xml/i',$a[0]) )
    return 'ERROR_CONTENT_TYPE_MISMATCH';
  // we do not filter the xml input, as we (the LB Team) should be the source and have
  // no intent to inject malicious code to our customers...
  $b = simplexml_load_string($a[1]);
  $m = substr(XF::VERSION,0,strrpos(XF::VERSION,'.'));
  $mp = 'path_'.str_replace('.','_',$m);
  $p = $b->{$mp};
  $p = explode(',',$p->allow);
  rsort($p);
  $a = '';
  //D($b);

    // do we have any advisories affecting the current installed release?
    foreach ( $b->security_advisory->item as $v ){
    $p = explode(',',$v->version);
      foreach ( $p as $v2 ){
        if ( preg_match('/^'.$v2.'$/m',XF::VERSION) ){
        $a = 'message_'.XF::get_cfg('main_language');
        $o['advisory'] = true;
        $o['sa_message'] = (string)$v->{$a};
        $o['sa_uri'] = (string)$v->uri;
        break 2;
        }
      }
    }

    foreach ( $p as $v ){
      // only allow one release as update...
      if ( sizeof($p) === 1 && !strpos($v,'*') ){
        foreach ( $b->release as $v3 ){
          if ( (string)$v3->version === $v && version_compare(XF::VERSION,(string)$v3->version,'<') ){
          $a = ( isset($v3->uri) ) ? $v3->uri : $b->basic_uri;
          $o = array('version'=>(string)$v3->version,'uri'=>(string)$a);
          break 2;
          }
        }
      }

    $vm = substr($v,0,strrpos($v,'.'));
      // iterate through every branch until we found our major and then search all releases until found...
      foreach ( $b->recent->branch as $v2 ){
        if ( (string)$v2->major === $vm ){
        $vs = (string)$v2->full;
          foreach ( $b->release as $v3 ){
            if ( (string)$v3->version === $vs && version_compare(XF::VERSION,(string)$v3->version,'<') ){
            $a = ( isset($v3->uri) ) ? $v3->uri : $b->basic_uri;
            $o = array('version'=>(string)$v3->version,'uri'=>(string)$a);
            break 3;
            }
          }
        }
      }
    }

  return $o;
  }

}
?>