;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define lw6-video-options-menu-fullscreen-item-label
  (lambda ()
    (let ((res (c-lw6gfx-get-video-mode)))
      (if (assoc-ref res "fullscreen")
	  (_ "Fullscreen")
	  (_ "Windowed")))))

(define lw6-video-options-menu-fullscreen-item-toggle
  (lambda ()
    (let ((res (c-lw6gfx-get-video-mode)))
      (begin
	(c-lw6gfx-set-video-mode (assoc-ref res "width")
				 (assoc-ref res "height")
				 (not (assoc-ref res "fullscreen")))
	(lw6-config-update-video)
	(lw6-menu-warp-mouse)))))

(define lw6-video-options-menu-fullscreen-item
  (lambda ()
    (let (
	  (item (lw6-menu-item-template-switch 
		 lw6-video-options-menu-fullscreen-item-label 
		 lw6-video-options-menu-fullscreen-item-toggle 
		 lw6-video-options-menu-fullscreen-item-toggle ))
	  )
      (begin
  	(assoc-set! item "selected" #t)
	item))))

(define lw6-res-equal?
  (lambda (res1 res2)
    (and (= (assoc-ref res1 "width") (assoc-ref res2 "width"))
	 (= (assoc-ref res1 "height") (assoc-ref res2 "height")))))

(define lw6-res-surface
  (lambda (res)
    (* (assoc-ref res "width") (assoc-ref res "height"))))

(define lw6-video-set-low
  (lambda ()
    (let ((res (c-lw6gfx-get-low-resolution)))
      (begin
	(c-lw6gfx-set-video-mode (assoc-ref res "width")
				 (assoc-ref res "height")
				 (assoc-ref (c-lw6gfx-get-video-mode) "fullscreen"))
	(lw6-config-update-video)
	(lw6-menu-warp-mouse)))))

(define lw6-video-set-standard
  (lambda ()
    (let ((res (c-lw6gfx-get-standard-resolution)))
      (begin
	(c-lw6gfx-set-video-mode (assoc-ref res "width")
				 (assoc-ref res "height")
				 (assoc-ref (c-lw6gfx-get-video-mode) "fullscreen"))
	(lw6-config-update-video)
	(lw6-menu-warp-mouse)))))

(define lw6-video-set-high
  (lambda ()
    (let ((res (c-lw6gfx-get-high-resolution)))
      (begin
	(c-lw6gfx-set-video-mode (assoc-ref res "width")
				 (assoc-ref res "height")
				 (assoc-ref (c-lw6gfx-get-video-mode) "fullscreen"))
	(lw6-config-update-video)
	(lw6-menu-warp-mouse)))))

(define lw6-video-options-menu-resolution-item-label
  (lambda ()
    (let (
	  (current-res (c-lw6gfx-get-video-mode))
	  (low-res (c-lw6gfx-get-low-resolution))
	  (standard-res (c-lw6gfx-get-standard-resolution))
	  (high-res (c-lw6gfx-get-high-resolution))
	  )
      (cond
       (
	(lw6-res-equal? current-res low-res)
	(_ "Low res")
	)
       (
	(lw6-res-equal? current-res standard-res)
	(_ "Standard res")
	)
       (
	(lw6-res-equal? current-res high-res)
	(_ "High res")
	)
       (
	#t
	(_ "User res")
	)
       ))))

(define lw6-video-options-menu-resolution-item-plus
  (lambda ()
    (let* (
	   (current-res (c-lw6gfx-get-video-mode))
	   (low-res (c-lw6gfx-get-low-resolution))
	   (standard-res (c-lw6gfx-get-standard-resolution))
	   (high-res (c-lw6gfx-get-high-resolution))
	   (current-surf (lw6-res-surface current-res))
	   (low-surf (lw6-res-surface low-res))
	   (standard-surf (lw6-res-surface standard-res))
	   (high-surf (lw6-res-surface high-res))
	   )
      (cond
       (
	(> current-surf standard-surf)
	(lw6-video-set-low)
	)
       (
	(= current-surf standard-surf)
	(lw6-video-set-high)
	)
       (
	#t
	(lw6-video-set-standard)
	)
    ))))

(define lw6-video-options-menu-resolution-item-minus
  (lambda ()
    (let* (
	   (current-res (c-lw6gfx-get-video-mode))
	   (low-res (c-lw6gfx-get-low-resolution))
	   (standard-res (c-lw6gfx-get-standard-resolution))
	   (high-res (c-lw6gfx-get-high-resolution))
	   (current-surf (lw6-res-surface current-res))
	   (low-surf (lw6-res-surface low-res))
	   (standard-surf (lw6-res-surface standard-res))
	   (high-surf (lw6-res-surface high-res))
	   )
      (cond
       (
	(< current-surf standard-surf)
	(lw6-video-set-high)
	)
       (
	(= current-surf standard-surf)
	(lw6-video-set-low)
	)
       (
	#t
	(lw6-video-set-standard)
	)
    ))))

(define lw6-video-options-menu-resolution-item
  (lambda ()
    (let (
	  (item (lw6-menu-item-template-switch 
		 lw6-video-options-menu-resolution-item-label 
		 lw6-video-options-menu-resolution-item-plus 
		 lw6-video-options-menu-resolution-item-minus ))
	  )
      item)))

(define lw6-video-options-menu-backend-item
  (lambda ()
    (let (
	  (item (lw6-menu-item-template (_ "Backend")))
	  )
      (begin
	item
	))))

(define lw6-video-options-menu
  (lambda()
    (let (
	  (menu (lw6-menu-template (_ "Video options")))
	  )
      (begin
	(lw6-append-menuitem! menu (lw6-video-options-menu-fullscreen-item))
	(lw6-append-menuitem! menu (lw6-video-options-menu-resolution-item))
;	(lw6-append-menuitem! menu (lw6-video-options-menu-backend-item))
	menu
	))))
