;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define lw6-main 
  (lambda () 
    (begin
      (load "def.scm")
      (load "backend.scm")
      (load "clear.scm")
      (load "color.scm")
      (load "command.scm")
      (load "config.scm")
      (load "console.scm")
      (load "control.scm")
      (load "cursor.scm")
      (load "demo.scm")
      (load "display.scm")
      (load "game.scm")
      (load "help.scm")
      (load "io.scm")
      (load "loader.scm")
      (load "local-game.scm")
      (load "log.scm")
      (load "loop.scm")
      (load "map.scm")
      (load "menu-engine.scm")
      (load "menu.scm")
      (load "menu-exit.scm")
      (load "menu-ingame.scm")
      (load "menu-map.scm")
      (load "menu-options.scm")
      (load "menu-options-map.scm")
      (load "menu-options-time.scm")
      (load "menu-options-rules.scm")
      (load "menu-options-audio.scm")
      (load "menu-options-video.scm")
      (load "menu-options-system.scm")
      (load "menu-play.scm")
      (load "menu-player-detail.scm")
      (load "menu-players.scm")
      (load "menu-root.scm")
      (load "menu-wait.scm")
      (load "mover.scm")
      (load "net.scm")
      (load "preview.scm")
      (load "quick-start.scm")
      (load "server.scm")
      (load "sound.scm")
      (load "speed.scm")
      (load "style.scm")

      ; Show the binary pedigree
      (lw6-log-notice (format #f (_ "running ~a") 
			      (c-lw6sys-get-script-file)))
      (c-lw6cfg-init)
      (lw6-load-config)
      (c-lw6sys-set-memory-bazooka-size (lw6-config-get-number lw6def-memory-bazooka-size))
      (c-lw6sys-set-memory-bazooka-eraser (lw6-config-is-true? lw6def-memory-bazooka-eraser))
      (c-lw6sys-dump-clear)
      (c-lw6ldr-print-examples)
      (c-lw6net-init)
      (let (
	    (gfx-backend (lw6-check-gfx-backend (lw6-config-get-string lw6def-gfx-backend)))
	    (snd-backend (lw6-check-snd-backend (lw6-config-get-string lw6def-snd-backend)))
	    )
	(if gfx-backend
	  (if (and (c-lw6gfx-create-backend gfx-backend)
	      (c-lw6gfx-init (lw6-config-get-number lw6def-width) 
			     (lw6-config-get-number lw6def-height) 
			     (lw6-config-is-true? lw6def-fullscreen) 
			     0
			     (lw6-config-get-number lw6def-key-repeat-delay) 
			     (lw6-config-get-number lw6def-key-repeat-interval)
			     ))
	      (begin
		(lw6-config-set-string! lw6def-gfx-backend gfx-backend)
		(lw6-config-update-video)
		(if (and snd-backend
			 (c-lw6snd-create-backend snd-backend)
			 (c-lw6snd-init (lw6-config-get-number lw6def-sound-volume) (lw6-config-get-number lw6def-music-volume))
			 )
		    (lw6-config-set-string! lw6def-snd-backend snd-backend)
		    )
		(lw6-play-sound-splash)
		(lw6-init-game-globals)
		(lw6-server-start)		
		(if (lw6-config-is-true? lw6def-display-console)
		    (begin
		      (c-lw6cns-init)
		      (lw6-console) ; usefull when piping commands at startup
		    ))
		(lw6-init-menu)
		(lw6-game-loop)
		(c-lw6cns-quit)
		(lw6-save-config)
		(lw6-server-stop)
		(lw6-clear)
		(c-lw6snd-quit)
		(c-lw6snd-destroy-backend)
		(c-lw6gfx-quit)
		(c-lw6gfx-destroy-backend)
		)
	      )
	  (begin
	    (lw6-log-info (_ "no graphical backend found, game can only run in pure server/console mode"))
	    (lw6-log-warning (_ "server mode not implemented yet"))
	    )
	  ))
      (c-lw6net-quit)
      (c-lw6cfg-quit)
      )
    )
  ) 


