;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;
;(at your option) any later version.
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

; returns map-source
(define (lw6-load-map path)
  (let (
	(level (c-lw6ldr-read-relative (c-lw6cfg-unified-get-map-path) path))
	)
    (list
     (cons "path" path)
     (cons "level" level)
     )
    )
  )

; returns game-instance
(define (lw6-prepare-map map-source)
  (let* (
	 (game-struct (c-lw6ker-build-game-struct (assoc-ref map-source "level")))
	 (game-state (c-lw6ker-build-game-state game-struct))
	 )
    (append map-source (list
			(cons "game-struct" game-struct)
			(cons "game-state" game-state)
			(cons "moves-per-tick" 
			      (/ (* (c-lw6map-options-get-int 
				     game-struct 
				     lw6def-moves-per-round)
				    (c-lw6map-options-get-int 
				     game-struct 
				     lw6def-rounds-per-sec)
				    ) 1000))
			)
	    )
    )
  )

(define lw6-load-chosen-map
  (lambda ()
    (let (
	  (chosen-map-source (lw6-load-map (lw6-config-get-string lw6def-chosen-map)))
	  )
      (begin    
	(lw6-set-game-global! "chosen-map-source" chosen-map-source)
	(lw6-update-map-source-from-chosen)
	)
      )
    )
  )
      
(define lw6-update-map-source-from-chosen
  (lambda ()
    (lw6-set-game-global! "map-source" (list-copy (lw6-get-game-global "chosen-map-source")))
    (lw6-set-game-global! "look" (c-lw6map-get-look (assoc-ref (lw6-get-game-global "map-source") "level")))
    (display "toto")
    )
  )
