/*
 * @(#)EnumerationType.java           1.0       6 September 1999
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2002 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.type;

import java.util.Vector;

/**
 * A class for handling integer type information.
 *
 * @version  1.0
 * @author   Per Cederberg, per@percederberg.net
 */
public class EnumerationType extends Type {

   /**
    * A vector with allowed values, or null for any value.
    */
   private Vector values;

   /**
    * A vector with the value lables, or null for no labels.
    */
   private Vector labels;

   /**
    * Creates a new enumeration type with no values.
    */
   public EnumerationType() {
      this.values = new Vector();
      this.labels = new Vector();
   }

   /**
    * Adds a value to the enumeration of possible values. If this
    * is the first value to be added, all other constraints will
    * be resetted.
    *
    * @param label     the constant name
    * @param value     the constant value
    */
   public void addValue(String label, Number value) {
      values.add(value);
      labels.add(label);
   }

   /**
    * Checks if this type is equal to some other object. It will not be
    * reported equal to any other object than itself or named aliases
    * of itself.
    *
    * @param  obj     an object
    *
    * @return true if the objects are equal, or
    *         false otherwise
    */
   public boolean equals(Object obj) {
      if (obj instanceof EnumerationType) {
         return this == obj;
      } else if (obj instanceof NamedType) {
         NamedType t = (NamedType)obj;
         return t.equals(this);
      } else {
         return false;
      }
   }

   /**
    * Returns a string description of this type.
    *
    * @return a string description of the type
    */
   public String toString() {
      return "Enumeration";
   }

   /**
    * Transfers the type information from this type to a type converter
    * object. The calling conventions declared in the TypeConverter
    * class are followed.
    *
    * @param   converter     a type converter
    */
   public void transferType(TypeConverter converter) {
      converter.createEnumeratedInteger(labels, values);
   }

}

