/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mib;

import net.percederberg.mib.Mib;
import net.percederberg.mib.SymbolFactory;
import net.percederberg.mib.asn1.analysis.DepthFirstAdapter;
import net.percederberg.mib.asn1.node.Node;
import net.percederberg.mib.symbol.Symbol;
import net.percederberg.mib.symbol.TypeSymbol;
import net.percederberg.mib.symbol.ValueSymbol;

class FirstPassAnalysis
extends DepthFirstAdapter {
    private Mib mib = null;
    private SymbolFactory factory = null;

    public FirstPassAnalysis(Mib mib) {
        this.mib = mib;
        this.factory = new SymbolFactory(mib);
    }

    protected void inStart(Node node) {
        this.mib.addSymbol(this.factory.createSymbol("iso"));
    }

    protected void outModuleDefinition(Node node) {
        String name = (String)this.getOut(node.childOfType(203));
        this.mib.setName(name);
    }

    protected void inTagDefault(Node node) {
        this.mib.addWarning("unsupported construct: ... TAGS", node.firstLine(), node.lastLine());
    }

    protected void outModuleIdentifier(Node node) {
        this.setOut(node, this.getOut(node.childOfType(267)));
    }

    protected void inExports(Node node) {
        this.mib.addWarning("unsupported construct: EXPORTS ...", node.firstLine(), node.lastLine());
    }

    protected void outSymbol(Node node) {
        if (node.isAncestor(206) && node.childrenOfType(270) == 0) {
            String id = (String)this.getOut(node.childOfType(266));
            Symbol sym = this.factory.findSymbol(id);
            if (sym != null) {
                this.mib.addSymbol(sym);
            } else {
                this.mib.addWarning("import unknown: " + id);
            }
        }
    }

    protected void inMacroDefinition(Node node) {
        this.mib.addWarning("unsupported construct: MACRO ...", node.firstLine(), node.lastLine());
    }

    protected void outTypeAssignment(Node node) {
        String id = (String)this.getOut(node.childOfType(268));
        this.mib.addSymbol(new TypeSymbol(id));
    }

    protected void inBitStringType(Node node) {
        this.mib.addWarning("unsupported type: BIT STRING", node.firstLine(), node.lastLine());
    }

    protected void inChoiceType(Node node) {
        this.mib.addWarning("unsupported type: CHOICE ...", node.firstLine(), node.lastLine());
    }

    protected void inEnumeratedType(Node node) {
        this.mib.addWarning("unsupported type: ENUMERATED ...", node.firstLine(), node.lastLine());
    }

    protected void inSelectionType(Node node) {
        this.mib.addWarning("unsupported type: name < ...", node.firstLine(), node.lastLine());
    }

    protected void inTaggedType(Node node) {
        this.mib.addWarning("unsupported type: [X] ...", node.firstLine(), node.lastLine());
    }

    protected void inAnyType(Node node) {
        this.mib.addWarning("unsupported type: ANY", node.firstLine(), node.lastLine());
    }

    protected void inAlphabetConstraint(Node node) {
        this.mib.addWarning("unsupported constraint: FROM ...", node.firstLine(), node.lastLine());
    }

    protected void outValueAssignment(Node node) {
        String id = (String)this.getOut(node.childOfType(266));
        this.mib.addSymbol(new ValueSymbol(id));
    }

    protected void outIdentifier(Node node) {
        this.setOut(node, this.getOut(node.childOfType(109)));
    }

    protected void outModuleReference(Node node) {
        this.setOut(node, this.getOut(node.childOfType(109)));
    }

    protected void outTypeReference(Node node) {
        this.setOut(node, this.getOut(node.childOfType(109)));
    }

    protected void inSnmpObjectGroupMacroType(Node node) {
        this.mib.addWarning("unsupported type: OBJECT-GROUP", node.firstLine(), node.lastLine());
    }

    protected void inSnmpNotificationGroupMacroType(Node node) {
        this.mib.addWarning("unsupported type: NOTIFICATION-GROUP", node.firstLine(), node.lastLine());
    }

    protected void inSnmpModuleComplianceMacroType(Node node) {
        this.mib.addWarning("unsupported type: MODULE-COMPLIANCE", node.firstLine(), node.lastLine());
    }

    protected void inSnmpAgentCapabilitiesMacroType(Node node) {
        this.mib.addWarning("unsupported type: AGENT-CAPABILITIES", node.firstLine(), node.lastLine());
    }

    protected void inTBOOLEAN(Node node) {
        this.mib.addWarning("unsupported type: BOOLEAN", node.firstLine(), node.lastLine());
    }

    protected void inTREAL(Node node) {
        this.mib.addWarning("unsupported type: REAL", node.firstLine(), node.lastLine());
    }

    protected void inTNULL(Node node) {
        this.mib.addWarning("unsupported type and value: NULL", node.firstLine(), node.lastLine());
    }

    protected void outTIDENT(Node node) {
        this.setOut(node, node.toString());
    }
}

