/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mib.type;

import java.util.Vector;
import net.percederberg.mib.type.Type;
import net.percederberg.mib.type.TypeConverter;

public class SnmpObjectType
extends Type {
    public static final int NO_ACCESS = 0;
    public static final int NOTIFY_ACCESS = 1;
    public static final int READ_ACCESS = 2;
    public static final int WRITE_ACCESS = 3;
    public static final int READ_WRITE_ACCESS = 4;
    public static final int READ_CREATE_ACCESS = 5;
    public static final int MANDATORY_STATUS = 1;
    public static final int OPTIONAL_STATUS = 2;
    public static final int CURRENT_STATUS = 3;
    public static final int DEPRECATED_STATUS = 4;
    public static final int OBSOLETE_STATUS = 5;
    private Type baseType;
    private int access;
    private int status;
    private String description;
    private Vector index;
    private Object defval;

    public SnmpObjectType(Type baseType, int access, int status) {
        this(baseType, access, status, null, null, null);
    }

    public SnmpObjectType(Type baseType, int access, int status, String descr, Vector index, Object defval) {
        this.baseType = baseType;
        this.access = access;
        this.status = status;
        this.description = descr;
        this.index = index;
        this.defval = defval;
    }

    public String getAccess() {
        switch (this.access) {
            case 0: {
                return "no access";
            }
            case 1: {
                return "notify";
            }
            case 2: {
                return "read";
            }
            case 3: {
                return "write";
            }
            case 4: {
                return "read-write";
            }
            case 5: {
                return "read-create";
            }
        }
        return "*** UNKNOWN ***";
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public Object getDefaultValue() {
        return this.defval;
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public String getIndices() {
        if (this.index == null) {
            return "";
        }
        return this.index.toString();
    }

    public String getStatus() {
        switch (this.status) {
            case 1: {
                return "mandatory";
            }
            case 2: {
                return "optional";
            }
            case 3: {
                return "current";
            }
            case 4: {
                return "deprecated";
            }
            case 5: {
                return "obsolete";
            }
        }
        return "*** UNKNOWN ***";
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        if (this.baseType != null) {
            return this.baseType.toString();
        }
        return "*** UNKNOWN TYPE ***";
    }

    public void transferType(TypeConverter converter) {
        this.baseType.transferType(converter);
        if (this.access >= 2 && this.access != 3) {
            converter.transferReadable(true);
        } else {
            converter.transferReadable(false);
        }
        if (this.access >= 3) {
            converter.transferWriteable(true);
        } else {
            converter.transferWriteable(false);
        }
        if (this.defval instanceof Integer) {
            converter.transferDefaultValue((Integer)this.defval);
        } else {
            converter.transferDefaultValue(this.defval.toString());
        }
    }
}

