/*
 * @(#)SnmpTextualConventionType.java
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2003 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.type;

/**
 * A class for handling type information for the SNMP textual 
 * convention macro type.
 *
 * @version  1.1
 * @author   Per Cederberg, per@percederberg.net
 */
public class SnmpTextualConventionType extends Type {
    // TODO: add methods for reading the instance variables

    /**
     * The object identity status.
     * 
     * @see net.percederberg.mib.type.SnmpObjectType#status
     */
    private int status = -1;

    /**
     * The description text.
     */
    private String description = null;

    /**
     * The optional reference text.
     */
    private String reference = null;

    /**
     * The optional display hint.
     */
    private String displayHint = null;

    /**
     * The type syntax.
     */
    private Type syntax = null;

    /**
     * Creates a new SNMP object identity type with the specified 
     * values.
     *
     * @param status    the status value
     * @param desc      the description text
     * @param ref       the reference text (or null)
     * @param hint      the display hint (or null)
     * @param syntax    the type syntax
     */
    public SnmpTextualConventionType(int status, 
                                     String desc, 
                                     String ref, 
                                     String hint, 
                                     Type syntax) {

        this.status = status;
        this.description = desc;
        this.reference = ref;
        this.displayHint = hint;
        this.syntax = syntax;
    }

    /**
     * Checks if this type equals another.
     *
     * @param  obj       an object
     * @return true if the types are equal, false otherwise
     */
    public boolean equals(Object obj) {
        return this == obj;
    }

    /**
     * Returns a description of this type.
     *
     * @return a description of the type
     */
    public String toString() {
        return "TextualConvention";
    }

    /**
     * Transfers the type information from this type to a type
     * converter object. The calling conventions declared in the
     * TypeConverter class are followed.
     *
     * @param   converter     a type converter
     */
    public void transferType(TypeConverter converter) {
        throw new UnsupportedOperationException(
            "This type cannot be mapped to anything.");
    }
}
