/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.percederberg.mib.FirstPassAnalysis;
import net.percederberg.mib.Message;
import net.percederberg.mib.SecondPassAnalysis;
import net.percederberg.mib.asn1.node.Node;
import net.percederberg.mib.asn1.parser.AsnParser;
import net.percederberg.mib.asn1.parser.ParseException;
import net.percederberg.mib.symbol.Symbol;

public class Mib {
    private File file = null;
    private String name = null;
    private Hashtable symbolTable = new Hashtable();
    private Vector symbolList = new Vector();
    private Vector errors = new Vector();
    private Vector warnings = new Vector();
    private Vector messages = new Vector();

    public Mib(String filename) throws FileNotFoundException, ParseException {
        this(new File(filename));
    }

    public Mib(File file) throws FileNotFoundException, ParseException {
        this.file = file;
        this.name = "";
        Node parseTree = AsnParser.parse(new FileInputStream(file));
        parseTree.apply(new FirstPassAnalysis(this));
        if (this.getErrorCount() == 0) {
            parseTree.apply(new SecondPassAnalysis(this));
        }
    }

    public boolean equals(Object obj) {
        return this.name.equals(obj.toString());
    }

    public String toString() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public int getSymbolCount() {
        return this.symbolList.size();
    }

    public Symbol getSymbol(int index) {
        if (index >= 0 && index < this.symbolList.size()) {
            return (Symbol)this.symbolList.get(index);
        }
        return null;
    }

    public Symbol getSymbol(String name) {
        return (Symbol)this.symbolTable.get(name);
    }

    public Enumeration getAllSymbols() {
        return this.symbolList.elements();
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    public String getError(int index) {
        if (index < 0 || index >= this.errors.size()) {
            return null;
        }
        return this.errors.get(index).toString();
    }

    public int getWarningCount() {
        return this.warnings.size();
    }

    public String getWarning(int index) {
        if (index < 0 || index >= this.warnings.size()) {
            return null;
        }
        return this.warnings.get(index).toString();
    }

    public int getMessageCount() {
        return this.messages.size();
    }

    public String getMessage(int index) {
        if (index < 0 || index >= this.messages.size()) {
            return null;
        }
        return this.messages.get(index).toString();
    }

    public String getAllMessages() {
        return this.vectorToString(this.errors) + this.vectorToString(this.warnings) + this.vectorToString(this.messages);
    }

    void setName(String name) {
        this.name = name;
    }

    void addSymbol(Symbol sym) {
        this.symbolTable.put(sym.getName(), sym);
        this.symbolList.addElement(sym);
    }

    void addError(String message) {
        this.errors.add(new Message(0, message));
    }

    void addError(String message, int firstLine, int lastLine) {
        this.errors.add(new Message(0, message, firstLine, lastLine));
    }

    void addWarning(String message) {
        this.warnings.add(new Message(1, message));
    }

    void addWarning(String message, int firstLine, int lastLine) {
        this.warnings.add(new Message(1, message, firstLine, lastLine));
    }

    void addMessage(String message) {
        this.messages.add(new Message(2, message));
    }

    void addMessage(String message, int firstLine, int lastLine) {
        this.messages.add(new Message(2, message, firstLine, lastLine));
    }

    private String vectorToString(Vector v) {
        String result = "";
        if (v == null) {
            return "";
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            result = result + e.nextElement() + "\n";
        }
        return result;
    }
}

