/**
 *
 * Ce programme explique comment utiliser de nouvelles polices de caractères
 * pour afficher du texte.
 *
 *------------------------------------------------------------------------------
 * MLV_Font* MLV_load_font : Charge une police de caractères en mémoire. Cette
 *                           police est chargée à partir du chemin d'accés du
 *                           fichier contenant la police et de la taille de la
 *                           police souhaitée.
 *
 * MLV_Font* MLV_load_font(
 *    const char*    file_font,    Chemin d'accès du fichier contenant la police
 *                                 de caractères
 *    int            size          Taille de la police de caractères
 * );
 *
 *------------------------------------------------------------------------------
 * void MLV_close_font : Ferme une police de caractères qui a précédement été
 *                       mis en mémoire.
 *
 * void MLV_close_font(
 *    MLV_Font*    font    La police de caractères à fermer.
 * );
 *
 *------------------------------------------------------------------------------
 * MLV_draw_text_with_font : Imprime un texte donné à une position, une police
 *                           de caractères et une couleur données.
 *
 * void MLV_draw_text_with_font(
 *     int             x,       Coordonnée en X de la position du coin
 *                              Nord-Ouest de la boîte
 *     int             y,       Coordonnée en Y de la position du coin
 *                              Nord-Ouest de la boîte
 *     const char *    text,    texte à afficher
 *     MLV_Font*       font,    police de caractères à utiliser pour afficher le
 *                              texte
 *     MLV_Color       color    couleur du tracé
 * );
 *
 *------------------------------------------------------------------------------
 */



#ifdef __cplusplus
extern "C" {
#endif
       #include <MLV/MLV_all.h>
#ifdef __cplusplus
}
#endif

//
// Programme principal
//
// Attention !
// Pour pouvoir compiler ce programme sous windows et sous macintosh,
// Il faut, pour la déclaration du main, respecter strictement la syntaxe
// suivante :
//
int main( int argc, char *argv[]){
	//
	// Créé et affiche la fenetre
	//
	MLV_create_window( "Nom_fenetre", "nom_icone", 640, 480 );

	//
	// Charge une font en mémoire
	//
	MLV_Font* font = MLV_load_font( "./data/font/Garuda-Oblique.ttf" , 20 );

	//
	// Affiche un texte avec la font qui vient d'être chargée
	//
	MLV_draw_text_with_font( 10, 10, "Le texte est écrit avec la font Garuda-Oblique.", font, MLV_COLOR_GREEN );

	//
	// Met à jour l'affichage de la fenêtre
	//
	MLV_actualise_window();

	//
	// Attend 5 seconde avant la fin du programme.
	//
	MLV_wait_seconds( 5 );


	//
	// Ferme proprement la font qui a été chargée en mémoire durant le
	// programme.
	//
	MLV_close_font( font );

	//
	// Ferme la fenetre
	//
	MLV_close_window();
	return 0;
}

