/*
 *   This file is part of the MLV Library.
 *
 *   Copyright (C) 2010 Adrien Boussicault, Marc Zipstein
 *
 *
 *    This Library is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This Library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this Library.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file MLV_all.h
 *
 * \author Adrien Boussicault
 * \author Marc Zipstein
 *
 * \brief Fichier d'entête principal incluant tous les autres fichiers entêtes de la librairie MLV.
 *
 * Vous trouverez tous les prototypes des fonctions proprées par la librairie MLV dans les fichiers entêtes (.h) suivants :
 * 
 * MLV_time.h : propose des outils pour gérer le temps.
 *
 * MLV_random.h : propose des outils pour engendrer des nombres aléatoires.
 *
 * 
 * MLV_window.h : propose des fonctions pour
 *     - initialiser, créer et fermer des fenêtres
 *     - actualiser l'affichage d'une fenetre
 *     - exécuter du code a la fin du programme
 *
 * 
 * MLV_color.h : definit les différentes couleurs de la librairie MLV.
 * 
 * 
 * MLV_figures.h : permet de créer des figures ( cercle, ellipse, polygone, courbe de bezier, rectangle, ligne , point).
 * 
 * 
 * MLV_text.h : définit differents outils permettant d'afficher du texte seul ou dans une boîte.
 * 
 * 
 * MLV_keyboard.h : définit les types concerant le clavier et définit la fonction MLV_keyboard_wait pour récuperer des évènements provenant du clavier.
 *
 *
 * MLV_mouse.h : définit les types concerant la souris ainsi que la fonction MLV_mouse_wait pour récuperer des évènements provenant du clavier.
 * 
 * 
 * MLV_prompt.h : définit différents outils pour créer et utiliser des prompts.
 * 
 * 
 * MLV_evenement.h : propose une gestion avancé des évènements. Avec les fonctions proposées par MLV_evenement.h, il est possible de traiter les évènements sans intérrompre l'exécution du programme.
 * 
 * 
 * MLV_image.h : permet d'afficher des images.
 * 
 * 
 * MLV_sound.h : permet de jouer de la musique.
 *
 *
 * \see MLV_time.h MLV_random.h MLV_window.h MLV_color.h MLV_figures.h MLV_text.h MLV_keyboard.h MLV_mouse.h MLV_prompt.h MLV_evenement.h MLV_image.h MLV_sound.h 
 */

#ifndef __MLV_ALL_H__
#define __MLV_ALL_H__

#include "MLV_time.h"
#include "MLV_random.h"
#include "MLV_window.h"
#include "MLV_color.h"
#include "MLV_figures.h"
#include "MLV_text.h"
#include "MLV_keyboard.h"
#include "MLV_mouse.h"
#include "MLV_prompt.h"
#include "MLV_evenement.h"
#include "MLV_image.h"
#include "MLV_sound.h"
#include "MLV_playlist.h"

#endif
