/*
 *   This file is part of the MLV Library.
 *
 *   Copyright (C) 2010 Adrien Boussicault, Marc Zipstein
 *
 *
 *    This Library is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This Library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this Library.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file MLV_mouse.h
 *
 * \author Adrien Boussicault
 * \author Marc Zipstein
 * 
 * Ce fichier définit les prototypes des fonctions qui permettent d'utiliser la
 * souris.
 *
 */

#ifndef __MLV_MOUSE_H__
#define __MLV_MOUSE_H__

#ifndef MEMORY_DEBUG
#include <SDL/SDL.h>
#else
#include "memory_debug.h"
#endif

/**
 * \brief Énumère les différents bouttons de la souris
 *
 */
typedef enum{
	MLV_BUTTON_LEFT = SDL_BUTTON_LEFT, /**< Bouton gauche de la souris */
	MLV_BUTTON_MIDDLE = SDL_BUTTON_MIDDLE, /**< Bouton du milieu de la souris */
	MLV_BUTTON_RIGHT = SDL_BUTTON_RIGHT /**< Bouton droit de la souris */
} MLV_Button;

/**
 *
 * \brief  Suspend l'exécution jusqu'à ce que l'utilisateur clique sur le bouton gauche de la souris.
 *
 * Au moment où l'utilisateur clique, la fonction retourne les
 * coordonnées de la position de la souris dans la fenêtre.
 *
 * \param x Coordonnée en X de la position de la souris dans la fenêtre.
 * \param y Coordonnée en Y de la position de la souris dans la fenêtre.
 */
void MLV_mouse_wait(int *x, int *y);

#endif
