#ifndef __MOBIUS_TSK_STREAM_H__
#define __MOBIUS_TSK_STREAM_H__
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
   Mobius Forensic Toolkit
   Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015 Eduardo Aguiar

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
   =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
#include <mobius/tsk/tsk.h>
#include <string>

struct TSK_FS_ATTR;	// forward declaration

namespace mobius
{
namespace tsk
{

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief entry data stream
//!\author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class stream
{
  const TSK_FS_ATTR *fs_attr_p_;
  offset_t offset_;
  offset_t size_;
  std::size_t idx_;

public:
  stream (const TSK_FS_ATTR * = 0, std::size_t = 0);
  std::size_t get_idx () const;
  int get_type () const;
  int get_flags () const;
  uint16_t get_id () const;
  offset_t get_size () const;
  const std::string get_name () const;
  operator bool () const;

  void seek (offset_t, int = 0);
  offset_t tell () const;
  offset_t read (char *, offset_t);
};

} // namespace tsk
} // namespace mobius

#endif