#ifndef __MOBIUS_CRYPT_CIPHER_DES_H__
#define __MOBIUS_CRYPT_CIPHER_DES_H__

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/crypt/cipher_block.h>
#include <mobius/crypt/cipher_block_mode_ecb.h>

namespace mobius
{
namespace crypt
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief DES cipher cryptographic algorithm
//! \author Eduardo Aguiar
//! \see http://csrc.nist.gov/publications/fips/fips46-3/fips46-3.pdf
//! \see http://page.math.tu-berlin.de/~kant/teaching/hess/krypto-ws2006/des.htm
//! \see http://en.wikipedia.org/wiki/Data_Encryption_Standard
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class cipher_des : public cipher_block
{
public:
  cipher_des (const mobius::bytearray&, cipher_block_mode * = new mobius::crypt::cipher_block_mode_ecb);

  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  //! \brief encrypt data block
  //! \param b data block
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  virtual void
  encrypt_block (mobius::bytearray& b) noexcept override
  {
    _crypt_block (b, true);
  }

  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  //! \brief decrypt data block
  //! \param b data block
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  virtual void
  decrypt_block (mobius::bytearray& b) noexcept override
  {
    _crypt_block (b, false);
  }

  std::uint64_t kn_[16];
  void _crypt_block (mobius::bytearray&, bool) noexcept;
};

} // namespace crypt
} // namespace mobius

#endif