#ifndef __MOBIUS_ANT_REGISTRY_REGISTRY_DATA_H__
#define __MOBIUS_ANT_REGISTRY_REGISTRY_DATA_H__

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/ant/registry/hive_data.h>
#include <mobius/bytearray.h>
#include <cstdint>
#include <memory>
#include <string>

namespace mobius
{
namespace ant
{
namespace registry
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief registry_data class
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class registry_data
{
public:
  // datatypes
  using data_type = hive_data::data_type;

  // constructors
  registry_data ();
  explicit registry_data (hive_data);
  registry_data (registry_data&&) = default;
  registry_data (const registry_data&) = default;

  // operators
  registry_data& operator= (const registry_data&) = default;
  registry_data& operator= (registry_data&&) = default;
  operator bool () const;

  // function prototypes
  std::uint32_t get_size () const;
  data_type get_type () const;

  // data getters
  const mobius::bytearray get_data () const;
  std::uint32_t get_data_as_dword () const;
  std::uint64_t get_data_as_qword () const;
  const std::string get_data_as_string (const std::string& = "ascii") const;

private:
  //! \brief implementation class forward declaration
  class impl;

  //! \brief implementation pointer
  std::shared_ptr <impl> impl_;
};

} // namespace registry
} // namespace ant
} // namespace mobius

#endif
