// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/system/device_list.h>
#include <mobius/core/application.h>
#include <iostream>
#include <unistd.h>

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief show usage text
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void
usage ()
{
  std::cerr << std::endl;
  std::cerr << "use: device_list" << std::endl;
  std::cerr << "e.g: device_list" << std::endl;
  std::cerr << std::endl;
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief main function
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
int
main (int argc, char **argv)
{
  mobius::core::application app;
  std::cerr << app.get_name () << " v" << app.get_version () << std::endl;
  std::cerr << app.get_copyright () << std::endl;
  std::cerr << "DeviceList v1.0" << std::endl;
  std::cerr << "by Eduardo Aguiar" << std::endl;

  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  // parse command line
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  int opt;

  while ((opt = getopt (argc, argv, "h")) != EOF)
    {
      switch (opt)
        {
          case 'h':
            usage ();
            exit (EXIT_SUCCESS);
            break;

          default:
            usage ();
            exit (EXIT_FAILURE);
        }
    }

  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  // show devices information
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  mobius::system::device_list dev_list;

  for (auto dev : dev_list)
    {
      std::cout << std::endl;
      std::cout << "type: " << dev.get_type () << std::endl;
      std::cout << "subsystem: " << dev.get_subsystem () << std::endl;
      std::cout << "node: " << dev.get_node () << std::endl;
      std::cout << "vendor: " << dev.get_property ("ID_VENDOR") << std::endl;
      std::cout << "model: " << dev.get_property ("ID_MODEL") << std::endl;

      if (dev.get_type () == "disk")
        {
          std::cout << "serial: " << dev.get_property ("ID_SERIAL_SHORT") << std::endl;
          std::cout << "revision: " << dev.get_property ("ID_REVISION") << std::endl;
          std::cout << "WWN: " << dev.get_property ("ID_WWN") << std::endl;
          std::cout << "sectors: " << dev.get_sysattr ("size") << std::endl;
          std::cout << "sector size: " << dev.get_sysattr ("queue/logical_block_size") << std::endl;
          std::cout << "properties:" << std::endl;
        }

      std::cout << "properties:" << std::endl;
      for (auto p : dev.get_property_list ())
        std::cout << "   " << p.first << " = " << p.second << std::endl;

      std::cout << "sysattrs:" << std::endl;
      for (auto p : dev.get_sysattr_list ())
        std::cout << "   " << p << std::endl;
    }
}
