#ifndef MOBIUS_CRYPT_HASH_SHA2_512_224_H
#define MOBIUS_CRYPT_HASH_SHA2_512_224_H

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/crypt/hash_block.h>

namespace mobius
{
namespace crypt
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief SHA-2 512/224 bits hash function implementation
//! \author Eduardo Aguiar
//! \see http://nvlpubs.nist.gov/nistpubs/FIPS/NIST.FIPS.180-4.pdf
//! \see https://en.wikipedia.org/wiki/SHA-2
//! \see https://tools.ietf.org/html/rfc6234
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class hash_sha2_512_224 : public hash_block
{
public:
  hash_sha2_512_224 () noexcept;

private:
  void _update_block (const mobius::bytearray&) noexcept override final;
  void _reset () noexcept override final;
  mobius::bytearray _evaluate (const mobius::bytearray&) override final;

  std::uint64_t a_;
  std::uint64_t b_;
  std::uint64_t c_;
  std::uint64_t d_;
  std::uint64_t e_;
  std::uint64_t f_;
  std::uint64_t g_;
  std::uint64_t h_;
  std::uint64_t size_;
};

} // crypt namespace
} // mobius namespace

#endif
