// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "item.h"
#include "cookie.h"

namespace mobius
{
namespace model
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Create new cookie
//! \param name Name
//! \param value Value
//! \param is_encrypted Is value encrypted?
//! \return Cookie
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
cookie
item::new_cookie (
  const std::string& name,
  const mobius::bytearray& value,
  bool is_encrypted)
{
  auto db = get_database ();

  auto stmt = db.new_statement (
                "INSERT INTO cookie "
                     "VALUES (NULL, ?, ?, ?, NULL, NULL, NULL, NULL, "
		             "NULL, 0, ?, NULL)");

  stmt.bind (1, get_uid ());
  stmt.bind (2, name);
  stmt.bind (3, value);
  stmt.bind (4, is_encrypted);
  stmt.execute ();

  auto uid = db.get_last_insert_row_id ();
  return cookie (*this, uid);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Get cookies
//! \return Cookies
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
std::vector <cookie>
item::get_cookies () const
{
  auto db = get_database ();

  auto stmt = db.new_statement (
                "SELECT uid "
                  "FROM cookie "
                 "WHERE item_uid = ?");

  stmt.bind (1, get_uid ());

  std::vector <cookie> cookies;

  while (stmt.fetch_row ())
    {
      auto uid = stmt.get_column_int64 (0);
      cookies.emplace_back (*this, uid);
    }

  return cookies;
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Remove cookies
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void
item::remove_cookies ()
{
  auto db = get_database ();

  auto stmt = db.new_statement (
                "DELETE FROM cookie "
                 "WHERE item_uid = ?");

  stmt.bind (1, get_uid ());
  stmt.execute ();
}

} // namespace model
} // namespace mobius
