// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief  C++ API mobius.disk module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <Python.h>
#include "disk.h"
#include "disk_device.h"
#include "disk_imagefile.h"
#include "disk_reader.h"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief functions prototypes
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject* func_new_disk_from_device_uid (PyObject *, PyObject *);
PyObject* func_new_disk_from_reader (PyObject *, PyObject *);
PyObject* func_new_disk_from_url (PyObject *, PyObject *);

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief module methods
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyMethodDef module_methods[] =
{
  {
    "new_disk_from_device_uid",
    func_new_disk_from_device_uid,
    METH_VARARGS,
    "create new disk from device UID"
  },
  {
    "new_disk_from_reader",
    func_new_disk_from_reader,
    METH_VARARGS,
    "create new disk from reader object"
  },
  {
    "new_disk_from_url",
    func_new_disk_from_url,
    METH_VARARGS,
    "create new disk from URL"
  },
  {
    NULL,
    NULL,
    0,
    NULL
  } // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief create mobius.disk module
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject *new_disk_module ()
{
  // initialize module
  PyObject* module = Py_InitModule3 (
                       "disk",
                       module_methods,
                       "Mobius Forensic Toolkit mobius.disk module"
                     );

  // build types
  if (PyType_Ready (&disk_disk_t) < 0)
    return nullptr;

  if (PyType_Ready (&disk_disk_device_t) < 0)
    return nullptr;

  if (PyType_Ready (&disk_disk_imagefile_t) < 0)
    return nullptr;

  if (PyType_Ready (&disk_disk_reader_t) < 0)
    return nullptr;

  // add types
  Py_INCREF (&disk_disk_t);
  PyModule_AddObject (module, "disk", (PyObject *) &disk_disk_t);

  Py_INCREF (&disk_disk_device_t);
  PyModule_AddObject (module, "disk_device", (PyObject *) &disk_disk_device_t);

  Py_INCREF (&disk_disk_imagefile_t);
  PyModule_AddObject (module, "disk_imagefile", (PyObject *) &disk_disk_imagefile_t);

  Py_INCREF (&disk_disk_reader_t);
  PyModule_AddObject (module, "disk_reader", (PyObject *) &disk_disk_reader_t);

  // return module
  return module;
}
