# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
import decoder_share_metadata
import mobius
import binascii

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Entry
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class Entry (object):

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief initialize object
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def __init__ (self):
    self.username = None
    self.path = None
    self.size = None
    self.title = None
    self.artist = None
    self.album = None
    self.category = None
    self.year = None
    self.language = None
    self.url = None
    self.comment = None
    self.filetype = None
    self.download_completed_time = None

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief decrypt data
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decrypt (data, seed):
  out = ''
  for c in data:
    out += chr (ord (c) ^ (seed >> 8))
    seed = ((ord (c) + seed) * 23219 + 36126) & 0xffff
  return out

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Decode data from ShareH.dat
# @see get_trusted_metas (helper_library_db.pas)
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode (f):

  # try to open file
  reader = f.new_reader ()
  if not reader:
    return

  # decode header
  decoder = mobius.decoder.data_decoder (reader)
  signature = decoder.get_string_by_size (14)
  
  if signature != '__ARESDB1.02H_':
    return

  # get ShareH.dat metadata
  shareh_path = f.path.replace ('/', '\\')
  shareh_creation_time = f.creation_time
  shareh_last_modification_time = f.last_modification_time

  # decode entries
  pos = decoder.tell ()
  size = decoder.get_size ()
  entries = []

  while pos < size:

    # entry header
    enc_data = decoder.get_bytearray_by_size (23)
    pos += 23
    data = decrypt (enc_data, 13871)

    entry = Entry ()
    entry.shareh_path = shareh_path
    entry.shareh_creation_time = shareh_creation_time
    entry.shareh_last_modification_time = shareh_last_modification_time
    entry.hash_sha1 = binascii.hexlify (data[:20])
    entry.flag_shared = ord (data[20]) == 1
    entry.flag_corrupted = False
    data_size = ord (data[21]) | (ord (data[22]) << 8)
    
    # entry metadata
    if data_size > 0:
      enc_data = decoder.get_bytearray_by_size (data_size)
      data = decrypt (enc_data, 13872)
      pos += data_size

      metadata = decoder_share_metadata.decode (data)
      for var, value in metadata.iteritems ():
        setattr (entry, var, value)

    # add entry
    entries.append (entry)

  return entries
