/* This file is part of the MPFRCPP Library.

  Copyright (c) 2006 -- 2007 Alexey V. Beshenov <bav.272304@gmail.com>.

  The MPFRCPP Library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) any later version.

  The MPFRCPP Library is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with the MPFRCPP Library; see the file COPYING.LIB. If
  not, write to the Free Software Foundation, Inc., 51 Franklin Street,
  Fifth Floor, Boston, MA 02110-1301, USA. */

/**
 * @file conversion.hpp
 * @date 2007-03-23
 * mpfrcpp::Real conversions, i.e. mpfrcpp::Real::operator T ()
 * for T = unsigned long int, unsigned int, unsigned short int,
 * long int, int, short int, double, long double, mpz_class, mpf_class.
 * INTERNAL HEADER, NOT TO BE USED DIRECTLY.
 */

#ifndef INCLUDED_BY_MPFRCPP
    #error THIS IS AN INTERNAL HEADER ONLY, NOT TO BE USED DIRECTLY
#endif

#ifndef MPFRCPP_REAL_CONVERSION
#define MPFRCPP_REAL_CONVERSION

namespace mpfrcpp {

    //------------------------------------------------------------

    Real::operator unsigned long int() const throw( ConversionDoesNotFitsError ) {
        if ( isFits<unsigned long int>() )
            return mpfr_get_ui( getMpfrT(),
                                getParameters().getDefaultRoundMode().getMpfrRndT() );
        else
            throw ConversionDoesNotFitsError();
    }
    Real::operator unsigned int() const throw( ConversionDoesNotFitsError ) {
        if ( isFits<unsigned int>() )
            return mpfr_get_ui( getMpfrT(),
                                getParameters().getDefaultRoundMode().getMpfrRndT() );
        else
            throw ConversionDoesNotFitsError();
    }
    Real::operator unsigned short int() const throw( ConversionDoesNotFitsError ) {
        if ( isFits<unsigned short int>() )
            return mpfr_get_ui( getMpfrT(),
                                getParameters().getDefaultRoundMode().getMpfrRndT() );
        else
            throw ConversionDoesNotFitsError();
    }

    //------------------------------------------------------------

    Real::operator long int() const throw( ConversionDoesNotFitsError ) {
        if ( isFits<long int>() )
            return mpfr_get_si( getMpfrT(),
                                getParameters().getDefaultRoundMode().getMpfrRndT() );
        else
            throw ConversionDoesNotFitsError();
    }

    Real::operator int() const throw( ConversionDoesNotFitsError ) {
        if ( isFits<int>() )
            return mpfr_get_si( getMpfrT(),
                                getParameters().getDefaultRoundMode().getMpfrRndT() );
        else
            throw ConversionDoesNotFitsError();
    }

    Real::operator short int() const throw( ConversionDoesNotFitsError ) {
        if ( isFits<short int>() )
            return mpfr_get_si( getMpfrT(),
                                getParameters().getDefaultRoundMode().getMpfrRndT() );
        else
            throw ConversionDoesNotFitsError();
    }

    //------------------------------------------------------------

    Real::operator double () const throw( ConversionDoesNotFitsError ) {
        if ( isFits<double>() )
            return mpfr_get_d( getMpfrT(),
                               getParameters().getDefaultRoundMode().getMpfrRndT() );
        else
            throw ConversionDoesNotFitsError();
    }

    //------------------------------------------------------------

    Real::operator long double () const throw( ConversionDoesNotFitsError ) {
        if ( isFits<long double>() )
            return mpfr_get_ld( getMpfrT(),
                                getParameters().getDefaultRoundMode().getMpfrRndT() );
        else
            throw ConversionDoesNotFitsError();
    }

    //------------------------------------------------------------

#ifdef GMP_CPP_INTERFACE
    Real::operator mpz_class () const throw() {
        mpz_t x;
        mpfr_get_z ( x, getMpfrT(),
                     getParameters().getDefaultRoundMode().getMpfrRndT() );
        return mpz_class( x );
    }

    //------------------------------------------------------------

    Real::operator mpf_class () const throw() {
        mpf_t x;
        mpfr_get_f ( x, getMpfrT(),
                     getParameters().getDefaultRoundMode().getMpfrRndT() );
        return mpf_class( x );
    }
#endif    // GMP_CPP_INTERFACE

    //------------------------------------------------------------

} // namespace mpfrcpp

#endif    // MPFRCPP_REAL_CONVERSION
