/* This file is part of the MPFRCPP Library.

   Copyright (c) 2006-2007 Alexey V. Beshenov <bav.272304@gmail.com>.

   The MPFRCPP Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of the
   License, or (at your option) any later version.

   The MPFRCPP Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the MPFRCPP Library; see the file COPYING.LIB. If
   not, write to the Free Software Foundation, Inc., 51 Franklin Street,
   Fifth Floor, Boston, MA 02110-1301, USA. */

/**
 * @file serialization.cpp
 * @date 2007-07-04
 */

#include <mpfrcpp/mpfrcpp.hpp>
#include <iostream>
#include <fstream>
#include <cstdlib>
#include <algorithm>
#include <iterator>
#include <list>

int main () {
    std::ofstream ofile ("foobar.mpfr");
    if (!ofile) std::exit(1);

    mpfr::Library.setPrecision(512);
    mpfr::Parameters.setDefaultBase(32);
    std::list<mpfr::Real> numbers;

    ofile.precision(0);
    std::cout.precision(0);

    for (size_t i = 0; i<100; i++) numbers.push_back(mpfr::Factorial(i));

    std::copy (numbers.begin(), numbers.end(),
               std::ostream_iterator<mpfr::Real> (ofile, "\n"));

    ofile.flush();

    std::ifstream ifile ("foobar.mpfr");
    if (!ifile) std::exit(1);
    numbers.resize(0);

    std::copy (std::istream_iterator<mpfr::Real> (ifile),
               std::istream_iterator<mpfr::Real> (),
               std::insert_iterator<std::list<mpfr::Real> >(numbers, numbers.end()));

    std::copy (numbers.begin(), numbers.end(),
               std::ostream_iterator<mpfr::Real> (std::cout, "\n"));

    return 0;
}
