/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.nongnu.multigraph.Edge;

class Node<N, E> {
    private Map<Node<N, E>, Map<E, Edge<N, E>>> edgelist = Collections.synchronizedMap(new HashMap());
    private Set<Edge<N, E>> all_edges = new HashSet<Edge<N, E>>();
    private Set<Edge<N, E>> all_edges_ro = Collections.unmodifiableSet(this.all_edges);
    final N unode;

    Node(N node) {
        this.unode = node;
    }

    void set(Node<N, E> to, int weight, E label) {
        Edge<N, E> e;
        Map<E, Edge<N, E>> to_edges = this.edgelist.get(to);
        assert (to != null);
        assert (label != null);
        if (to_edges != null && (e = to_edges.get(label)) != null) {
            e.set_weight(weight);
            return;
        }
        if (to_edges == null) {
            to_edges = new HashMap<E, Edge<N, E>>();
            this.edgelist.put(to, to_edges);
        }
        e = new Edge<N, E>(this.unode, to.unode, weight, label);
        this.all_edges.add(e);
        to_edges.put(label, e);
    }

    private boolean _remove(Node<N, E> to, E label, boolean clear, Iterator<Node<N, E>> edgelist_it) {
        Map<E, Edge<N, E>> to_edges = this.edgelist.get(to);
        assert (to != null);
        if (to_edges == null) {
            return false;
        }
        Edge<N, E> e = to_edges.get(label);
        if (label != null && to_edges.remove(label) != null) {
            assert (this.all_edges.size() > 0);
            boolean ret = this.all_edges.remove(e);
            if (to_edges.isEmpty()) {
                if (edgelist_it == null) {
                    return this.edgelist.remove(to) != null;
                }
                edgelist_it.remove();
            }
            return ret;
        }
        if (!clear) {
            return false;
        }
        this.all_edges.removeAll(to_edges.values());
        to_edges.clear();
        if (edgelist_it == null) {
            return this.edgelist.remove(to) != null;
        }
        edgelist_it.remove();
        return true;
    }

    boolean remove(Node<N, E> to, E label) {
        assert (to != null);
        assert (label != null);
        return this._remove(to, label, false, null);
    }

    boolean remove(Node<N, E> to) {
        assert (to != null);
        boolean ret = true;
        for (Edge<N, E> e : this.edges(to)) {
            if (this._remove(to, e.label(), false, null)) continue;
            ret = false;
        }
        return ret;
    }

    boolean clear() {
        boolean ret = true;
        Iterator<Node<N, E>> it = this.edgelist.keySet().iterator();
        while (it.hasNext()) {
            if (this._remove(it.next(), null, true, it)) continue;
            ret = false;
        }
        return ret;
    }

    int nodal_outdegree() {
        return this.edgelist.size();
    }

    int edge_outdegree() {
        return this.all_edges.size();
    }

    Collection<Map<E, Edge<N, E>>> edgelist() {
        return this.edgelist.values();
    }

    Set<Edge<N, E>> edges() {
        return this.all_edges_ro;
    }

    Collection<Edge<N, E>> edges(Node<N, E> to) {
        if (to == null) {
            throw new NullPointerException("Node get requires non-null argument");
        }
        Map<E, Edge<N, E>> edges = this.edgelist.get(to);
        if (edges == null) {
            return Collections.emptySet();
        }
        return edges.values();
    }

    Stream<Edge<N, E>> stream() {
        return this.all_edges.stream();
    }

    Edge<N, E> edge(Node<N, E> to) {
        if (to == null) {
            throw new NullPointerException("Node get requires non-null argument");
        }
        Map<E, Edge<N, E>> edges = this.edgelist.get(to);
        if (edges == null || edges.isEmpty()) {
            return null;
        }
        return edges.values().iterator().next();
    }

    boolean isLinked(Node<N, E> to) {
        if (to == null) {
            throw new NullPointerException("Node get requires non-null argument");
        }
        return this.edgelist.containsKey(to);
    }

    public String toString() {
        return this.unode.toString();
    }
}

