/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.layout;

import java.awt.Dimension;
import java.util.Random;
import org.nongnu.multigraph.Edge;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.debug;
import org.nongnu.multigraph.layout.Layout;
import org.nongnu.multigraph.layout.PositionableNode;
import org.nongnu.multigraph.layout.Vector2D;

public class ForceLayout<N extends PositionableNode, E>
extends Layout<N, E> {
    private double k;
    private double mintemp = 0.001;
    private double C = 0.78;
    private double minkve = 0.2;
    private double jiggle = 0.001;
    private double mass_exponent = 0.0;
    private double temperature = 1.2;
    private double decay = 0.96;

    private void _setk() {
        double min = Math.min(this.bound.getWidth(), this.bound.getHeight());
        this.k = this.C * Math.sqrt(min * min / (double)this.graph.size());
        debug.println("k: " + this.k);
    }

    public ForceLayout(Graph<N, E> graph, Dimension bound, int maxiterations) {
        super(graph, bound, maxiterations);
        this._setk();
    }

    public ForceLayout(Graph<N, E> graph, Dimension bound, int maxiterations, double initial_temperature) {
        super(graph, bound, maxiterations);
        this.temperature = initial_temperature;
        this._setk();
    }

    public ForceLayout(Graph<N, E> graph, Dimension bound, int maxiterations, double initial_temperature, double C) {
        super(graph, bound, maxiterations);
        this.temperature = initial_temperature;
        this._setk();
    }

    private double attraction(double delta) {
        return delta * delta / this.k;
    }

    private double repulsion(float mass, double delta) {
        double f = this.k * this.k / delta;
        if (this.mass_exponent != 0.0) {
            f *= Math.pow(mass, this.mass_exponent);
        }
        return f;
    }

    private double decay(double temperature) {
        return temperature * this.decay;
    }

    public ForceLayout<N, E> setMintemp(double mintemp) {
        this.mintemp = mintemp;
        return this;
    }

    public ForceLayout<N, E> setDecay(double decay) {
        this.decay = decay;
        return this;
    }

    public ForceLayout<N, E> setMinkve(double minkve) {
        this.minkve = minkve;
        return this;
    }

    public ForceLayout<N, E> setC(double C) {
        this.C = C;
        this._setk();
        return this;
    }

    public void setJiggle(double jiggle) {
        this.jiggle = jiggle;
    }

    public void setMassExponent(double mass_exponent) {
        this.mass_exponent = mass_exponent;
    }

    @Override
    public boolean layout(float interval) {
        double sumkve = 0.0;
        double maxkve = 0.0;
        double sumv = 0.0;
        Random r = new Random();
        debug.println("force-layout start");
        if (!super.layout(interval)) {
            return false;
        }
        for (PositionableNode n : this.graph) {
            Vector2D delta;
            Vector2D disp = n.getVelocity();
            disp.setLocation(0.0, 0.0);
            debug.printf("node: %s, pos: %s\n", n, n.getPosition());
            for (PositionableNode positionableNode : this.graph) {
                if (positionableNode == n) continue;
                if (positionableNode.getPosition().distanceSq(n.getPosition()) <= 1.0) {
                    Vector2D vrandom = new Vector2D(2.0, 0.0);
                    vrandom.rotate(r.nextInt(360));
                    positionableNode.getPosition().plus(vrandom);
                }
                debug.printf("\trepulsion with %s, %s\n", positionableNode, positionableNode.getPosition());
                delta = new Vector2D(n.getPosition());
                delta.minus(positionableNode.getPosition());
                debug.println("\t\tdelta1: " + delta);
                double repf = this.repulsion(n.getMass(), delta.length());
                debug.println("\t\trepf: " + repf);
                delta.normalise();
                delta.times(repf);
                debug.println("\t\tdelta2: " + delta);
                disp.plus(delta);
                debug.println("\tdisp after repf: " + disp);
            }
            for (Edge edge : this.graph.edges(n)) {
                if (edge.to() == edge.from()) continue;
                debug.printf("\tattraction with %s\n", edge.to());
                delta = new Vector2D(n.getPosition());
                delta.minus(((PositionableNode)edge.to()).getPosition());
                debug.println("\t\tdelta1: " + delta + ", len " + delta.length());
                double attrf = this.attraction(delta.length());
                debug.println("\t\tattrf: " + (attrf *= Math.max(0.0, r.nextGaussian()) * this.jiggle + 1.0));
                delta.normalise();
                delta.times(attrf);
                debug.println("\t\tdelta2: " + delta);
                disp.minus(delta);
                debug.println("\tdisp: " + disp);
            }
            disp.rotate(Math.toRadians(r.nextGaussian() / 3.0 * 10.0 * this.jiggle));
            debug.println("\tresultant v: " + disp);
            Vector2D pos = n.getPosition();
            Vector2D vector2D = n.getVelocity();
            debug.printf("node pos: %s\n", pos);
            debug.printf("\tv: %s\n", vector2D);
            this.temperature = Math.max(this.decay(this.temperature), this.mintemp);
            vector2D.times((double)interval * this.temperature);
            debug.printf("\tv2: %s\n", vector2D);
            pos.plus(vector2D);
            debug.printf("\tp2: %s\n", pos);
            pos.x = Math.min(Math.max((double)(-this.bound.width / 2), pos.x), (double)(this.bound.width / 2));
            pos.y = Math.min(Math.max((double)(-this.bound.height / 2), pos.y), (double)(this.bound.height / 2));
            double mag = vector2D.magnitude();
            double kve = (double)n.getMass() * mag * mag;
            sumv += mag;
            sumkve += kve;
            maxkve = Math.max(maxkve, kve);
            debug.println("\tresult: " + pos);
        }
        long gsz = this.graph.size();
        double avgkve = sumkve / (double)gsz;
        debug.println("sumkve: " + sumkve);
        debug.println("avgkve: " + avgkve);
        debug.println("maxkve: " + maxkve);
        debug.println("sumv  : " + sumv);
        debug.println("avgv  : " + sumv / (double)gsz);
        return avgkve > this.minkve;
    }
}

