/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.layout;

import java.awt.Dimension;
import java.lang.reflect.Constructor;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.layout.PositionableNode;

public abstract class Layout<N extends PositionableNode, E> {
    Graph<N, E> graph;
    int maxiterations;
    int iterations = 0;
    Dimension bound;
    int border;

    public int maxiterations() {
        return this.maxiterations;
    }

    public Layout<N, E> maxiterations(int maxiterations) {
        this.maxiterations = maxiterations;
        return this;
    }

    public Layout(Graph<N, E> graph, Dimension bound) {
        this.graph = graph;
        this.maxiterations = 0;
        this.bound = bound;
    }

    public Layout(Graph<N, E> graph, Dimension bound, int maxiterations) {
        this.graph = graph;
        this.maxiterations = maxiterations;
        this.bound = bound;
    }

    public boolean layout(float interval) {
        return this.maxiterations > 0 ? this.iterations++ < this.maxiterations : true;
    }

    private static String alg2class_name(String algorithm) {
        return Layout.class.getPackage().getName() + "." + algorithm + "Layout";
    }

    public static boolean isaLayout(String name) {
        try {
            Class.forName(Layout.alg2class_name(name));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    private static <N extends PositionableNode, L> Constructor<? extends Layout<N, L>> factory_con(String classname) {
        Class<?> client_class = null;
        Constructor<?> c = null;
        try {
            client_class = Class.forName(classname);
        }
        catch (Exception e) {
            System.out.println("Client class doesn't exist: ");
            System.out.println(e);
            System.exit(1);
        }
        if (client_class == null) {
            return null;
        }
        try {
            c = client_class.getConstructor(Graph.class, Dimension.class, Integer.TYPE);
        }
        catch (Exception e) {
            System.out.println("Error settting up client class: ");
            System.out.println(e.toString());
            System.exit(1);
        }
        if (c == null) {
            return null;
        }
        return c;
    }

    public static final <N extends PositionableNode, L> Layout<N, L> factory(String algname, Graph<N, L> graph, Dimension bound, int maxiterations) {
        Layout<N, L> dp = null;
        Constructor<Layout<N, L>> c = Layout.factory_con(Layout.alg2class_name(algname));
        try {
            dp = c.newInstance(graph, bound, maxiterations);
        }
        catch (Exception e) {
            System.out.println("Error creating instance of client class: ");
            System.out.println(e.toString());
            System.exit(1);
        }
        return dp;
    }
}

