/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.perturb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.nongnu.multigraph.Edge;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.perturb.perturber;

public class RandomRemove<N, E>
implements perturber<N, E> {
    private List<Edge<N, E>> removed_remembered_edges = new ArrayList<Edge<N, E>>();
    private Graph<N, E> network;
    private int remove_edges = 1;
    private int maxperturbs = -1;
    private int runs = 0;
    private List<Edge<N, E>> run_perturb_edges = null;
    private boolean combine = false;

    public void combine(boolean combine) {
        this.combine = combine;
    }

    public boolean combine() {
        return this.combine;
    }

    private void setup() {
        this.run_perturb_edges = new LinkedList<Edge<N, E>>();
        for (Object h : this.network) {
            for (Edge<N, E> edge : this.network.edges(h)) {
                this.run_perturb_edges.add(edge);
            }
        }
    }

    public RandomRemove(Graph<N, E> graph) {
        this.network = graph;
        this.setup();
    }

    public RandomRemove(Graph<N, E> graph, float remove_edges) {
        this.network = graph;
        this.remove_edges = (int)(remove_edges < 1.0f ? Math.max((float)this.network.size() * remove_edges, 1.0f) : remove_edges);
        this.setup();
    }

    public RandomRemove(Graph<N, E> graph, float remove_edges, int max_perturbs) {
        this.network = graph;
        this.maxperturbs = max_perturbs;
        this.remove_edges = (int)(remove_edges < 1.0f ? Math.max((float)this.network.size() * remove_edges, 1.0f) : remove_edges);
        this.setup();
    }

    public List<Edge<N, E>> remove() {
        N h;
        Iterator<Edge<N, E>> ite;
        ArrayList<Edge<N, E>> removed_edges = new ArrayList<Edge<N, E>>();
        Iterator<N> ith = this.network.random_node_iterable().iterator();
        for (int num = this.remove_edges; ith.hasNext() && num > 0 && (ite = this.network.random_edge_iterable(h = ith.next()).iterator()).hasNext(); --num) {
            Edge<N, E> e = ite.next();
            removed_edges.add(e);
            this.network.remove(h, e.to());
        }
        this.removed_remembered_edges.addAll(removed_edges);
        return Collections.unmodifiableList(removed_edges);
    }

    @Override
    public int restore() {
        int size = this.removed_remembered_edges.size();
        for (Edge<N, E> e : this.removed_remembered_edges) {
            this.network.set(e.from(), e.to(), e.label());
        }
        this.removed_remembered_edges.clear();
        return size;
    }

    @Override
    public List<Edge<N, E>> removed_edges() {
        return Collections.unmodifiableList(this.removed_remembered_edges);
    }

    @Override
    public int clear_removed_edges() {
        int size = this.removed_remembered_edges.size();
        this.removed_remembered_edges.clear();
        return size;
    }

    @Override
    public List<Edge<N, E>> perturb() {
        int num = this.restore();
        this.clear_removed_edges();
        if (!this.combine && num > 0) {
            return Collections.EMPTY_LIST;
        }
        if (this.maxperturbs > 0 && this.runs >= this.maxperturbs) {
            return Collections.EMPTY_LIST;
        }
        ++this.runs;
        return this.remove();
    }
}

