/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.rewire;

import java.lang.reflect.Constructor;
import org.nongnu.multigraph.EdgeLabeler;
import org.nongnu.multigraph.Graph;

public abstract class Rewire<N, E> {
    protected Graph<N, E> graph;
    protected EdgeLabeler<N, E> el;

    public Rewire(Graph<N, E> graph, EdgeLabeler<N, E> el) {
        this.graph = graph;
        this.el = el;
    }

    public abstract void rewire();

    public void add(N node) {
        throw new UnsupportedOperationException();
    }

    private static String alg2class_name(String algorithm) {
        return Rewire.class.getPackage().getName() + "." + algorithm + "Rewire";
    }

    public static boolean isaRewire(String name) {
        try {
            Class.forName(Rewire.alg2class_name(name));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    private static <N, L> Constructor<? extends Rewire<N, L>> factory_con(String classname) {
        Class<?> client_class = null;
        Constructor<?> c = null;
        try {
            client_class = Class.forName(classname);
        }
        catch (Exception e) {
            System.out.println("Client class doesn't exist: ");
            System.out.println(e);
            System.exit(1);
        }
        if (client_class == null) {
            return null;
        }
        try {
            c = client_class.getConstructor(Graph.class, EdgeLabeler.class);
        }
        catch (Exception e) {
            System.out.println("Error settting up client class: ");
            System.out.println(e.toString());
            System.exit(1);
        }
        if (c == null) {
            return null;
        }
        return c;
    }

    public static final <N, L> Rewire<N, L> factory(String algname, Graph<N, L> graph, EdgeLabeler<N, L> el) {
        Rewire<N, L> dp = null;
        Constructor<Rewire<N, L>> c = Rewire.factory_con(Rewire.alg2class_name(algname));
        try {
            dp = c.newInstance(graph, el);
        }
        catch (Exception e) {
            System.out.println("Error creating instance of client class: ");
            System.out.println(e.toString());
            System.exit(1);
        }
        return dp;
    }
}

