/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.structure;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.nongnu.multigraph.Edge;
import org.nongnu.multigraph.Graph;

public class graph_diff<N, E> {
    private final Graph<N, E> gold;
    private final Graph<N, E> gnew;
    private final node_callback<N> node_cb;
    private final edge_callback<N, E> edge_cb;
    private final Set<N> all;
    private final Iterator<N> it;

    public graph_diff(Graph<N, E> old_graph, Graph<N, E> new_graph, node_callback<N> node_cb, edge_callback<N, E> edge_cb) {
        if (old_graph == null || new_graph == null) {
            throw new IllegalArgumentException("Graph arguments may not be null!");
        }
        if (node_cb == null && edge_cb == null) {
            throw new IllegalArgumentException("At least one callback argument required!");
        }
        this.gold = old_graph;
        this.gnew = new_graph;
        this.node_cb = node_cb;
        this.edge_cb = edge_cb;
        this.all = new HashSet<N>(this.gold);
        this.all.addAll(this.gnew);
        this.it = this.all.iterator();
    }

    private void _compare_edges(N n) {
        if (this.edge_cb == null) {
            return;
        }
        HashSet<Edge<N, Edge<N, E>>> edges = new HashSet<Edge<N, Edge<N, E>>>(this.gold.edges(n));
        edges.addAll(this.gnew.edges(n));
        for (Edge edge : edges) {
            boolean einnew;
            boolean einold = edges.contains(edge);
            if (einold == (einnew = edges.contains(edge))) continue;
            this.edge_cb.action(edge, einnew ? change_state.added : change_state.removed);
        }
    }

    public boolean compare_next() {
        boolean innew;
        if (!this.it.hasNext()) {
            return false;
        }
        N n = this.it.next();
        boolean inold = this.gold.contains(n);
        if (inold != (innew = this.gnew.contains(n))) {
            change_state s;
            change_state change_state2 = s = innew ? change_state.added : change_state.removed;
            if (this.node_cb != null) {
                this.node_cb.action(n, s);
            }
            if (this.edge_cb != null) {
                Graph<N, E> ingraph = innew ? this.gnew : this.gold;
                Set<Edge<N, E>> edges = ingraph.edges(n);
                for (Edge<N, E> e : edges) {
                    this.edge_cb.action(e, s);
                }
            }
        } else {
            this._compare_edges(n);
        }
        return true;
    }

    public void compare() {
        while (this.compare_next()) {
        }
    }

    public static interface edge_callback<N, E> {
        public void action(Edge<N, E> var1, change_state var2);
    }

    public static interface node_callback<N> {
        public void action(N var1, change_state var2);
    }

    public static enum change_state {
        added,
        removed;

    }
}

