/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.nongnu.multigraph.Edge;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.Node;

public class MultiDiGraph<N, L>
implements Graph<N, L> {
    HashMap<N, Node<N, L>> nodes = new HashMap();
    private Set<N> nodeset = this.nodes.keySet();

    final Node<N, L> get_node(N n) {
        Node<N, L> node = this.nodes.get(n);
        if (node == null) {
            node = new Node(n);
            this.nodes.put(n, node);
        }
        return node;
    }

    final void _set(Node<N, L> node, Node<N, L> node2, int n, L l) {
        assert (node != null);
        assert (node2 != null);
        assert (l != null);
        node.set(node2, n == 0 ? n : 1, l);
    }

    protected void _set(N n, N n2, int n3, L l) {
        Node<N, L> node = null;
        assert (n != null);
        Node<N, L> node2 = this.get_node(n);
        node = n2 == null || n2 == n ? node2 : this.get_node(n2);
        this._set((N)node2, (N)node, n3, l);
    }

    @Override
    public synchronized void set(N n, N n2, L l) {
        this._set(n, n2, 1, l);
    }

    @Override
    public synchronized void set(N n, N n2, L l, int n3) {
        this._set(n, n2, n3, l);
    }

    protected boolean _remove(N n, N n2, L l) {
        Node<N, L> node = null;
        if (n == null) {
            throw new NullPointerException("remove: 'from' must not be null");
        }
        if (n2 == null) {
            throw new NullPointerException("remove: 'from' must not be null");
        }
        Node<N, L> node2 = this.nodes.get(n);
        if (node2 == null) {
            return false;
        }
        Node<N, L> node3 = node = n2 == n ? node2 : this.nodes.get(n2);
        if (node == null) {
            return false;
        }
        if (l != null) {
            return node2.remove(node, l);
        }
        return node2.remove(node);
    }

    @Override
    public synchronized boolean remove(N n, N n2, L l) {
        return this._remove(n, n2, l);
    }

    @Override
    public synchronized boolean remove(N n, N n2) {
        return this._remove(n, n2, null);
    }

    @Override
    public synchronized Set<Edge<N, L>> edges(N n) {
        Node<N, L> node = this.nodes.get(n);
        if (node == null) {
            return null;
        }
        return Collections.unmodifiableSet(node.edges());
    }

    @Override
    public synchronized Collection<Edge<N, L>> edges(N n, N n2) {
        Node<N, L> node = this.nodes.get(n);
        if (node == null) {
            return null;
        }
        Node<N, L> node2 = this.nodes.get(n2);
        if (node2 == null) {
            return null;
        }
        return Collections.unmodifiableCollection(node.edges(node2));
    }

    @Override
    public Edge<N, L> edge(N n, N n2) {
        Collection<Edge<N, L>> collection = this.edges(n, n2);
        if (collection == null) {
            return null;
        }
        Iterator<Edge<N, L>> iterator = collection.iterator();
        if (iterator.hasNext()) {
            Edge<N, L> edge = iterator.next();
            return edge;
        }
        return null;
    }

    @Override
    public Edge<N, L> edge(N n, N n2, L l) {
        Collection<Edge<N, L>> collection = this.edges(n, n2);
        if (collection == null) {
            return null;
        }
        for (Edge<N, L> edge : collection) {
            if (edge.label() != l) continue;
            return edge;
        }
        return null;
    }

    @Override
    public synchronized Set<N> successors(N n) {
        HashSet<N> hashSet = new HashSet<N>();
        assert (n != null);
        Node<N, L> node = this.nodes.get(n);
        if (node == null) {
            return null;
        }
        for (Edge<N, L> edge : node.edges()) {
            hashSet.add(edge.to());
        }
        return hashSet;
    }

    @Override
    public synchronized int edge_outdegree(N n) {
        return this.get_node(n).edge_outdegree();
    }

    @Override
    public synchronized int nodal_outdegree(N n) {
        return this.get_node(n).nodal_outdegree();
    }

    @Override
    public synchronized float avg_nodal_degree() {
        float f = 0.0f;
        int n = 0;
        for (Node<N, L> node : this.nodes.values()) {
            f += ((float)node.nodal_outdegree() - f) / (float)(++n);
        }
        return f;
    }

    @Override
    public synchronized int max_nodal_degree() {
        int n = 0;
        for (Node<N, L> node : this.nodes.values()) {
            int n2 = node.nodal_outdegree();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node<N, L> node : this.nodes.values()) {
            stringBuilder.append(node + "\n");
            for (Edge<N, L> edge : node.edges()) {
                stringBuilder.append("\t" + edge + "\n");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean add(N n) {
        return this.get_node(n) != null;
    }

    @Override
    public boolean addAll(Collection<? extends N> collection) {
        return this.nodeset.addAll(collection);
    }

    @Override
    public void clear() {
        this.nodes.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.nodeset.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.nodeset.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        return ((Object)this.nodeset).equals(object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.nodeset).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.nodeset.isEmpty();
    }

    @Override
    public int size() {
        return this.nodeset.size();
    }

    @Override
    public Object[] toArray() {
        return this.nodeset.toArray();
    }

    @Override
    public <N> N[] toArray(N[] NArray) {
        return this.nodeset.toArray(NArray);
    }

    @Override
    public Iterator<N> iterator() {
        return this.nodeset.iterator();
    }

    @Override
    public void clear_all_edges() {
        for (Node<N, L> node : this.nodes.values()) {
            node.clear();
        }
    }

    @Override
    public synchronized boolean remove(Object object) {
        Node<N, L> node = this.nodes.get(object);
        boolean bl = false;
        if (node == null) {
            return false;
        }
        for (Object object2 : node.edges().toArray()) {
            Edge edge = (Edge)object2;
            if (!this.remove(edge.from(), edge.to(), edge.label())) continue;
            bl = true;
        }
        return this.nodeset.remove(object) ? true : bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        int n = this.size();
        for (Object obj : collection) {
            this.remove(obj);
        }
        return n == this.size();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        int n = this.size();
        for (N n2 : this) {
            if (collection.contains(n2)) continue;
            this.remove((Object)n2);
        }
        return n == this.size();
    }
}

