/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.layout;

import java.awt.Dimension;
import java.util.Random;
import org.nongnu.multigraph.Edge;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.debug;
import org.nongnu.multigraph.layout.Layout;
import org.nongnu.multigraph.layout.PositionableNode;
import org.nongnu.multigraph.layout.Vector2D;

public class ForceLayout<N extends PositionableNode, L>
extends Layout<N, L> {
    private double k;
    private double mintemp = 0.001;
    private double C = 0.5;
    private double minkve = 0.001;
    private double jiggle = 0.1;
    private double temperature = 1.2;
    private double decay = 0.96;

    private void _setk() {
        double d = Math.min(this.bound.getWidth(), this.bound.getHeight());
        this.k = this.C * Math.sqrt(d * d / (double)this.graph.size());
        debug.println("k: " + this.k);
    }

    public ForceLayout(Graph<N, L> graph, Dimension dimension, int n) {
        super(graph, dimension, n);
        this._setk();
    }

    public ForceLayout(Graph<N, L> graph, Dimension dimension, int n, double d) {
        super(graph, dimension, n);
        this.temperature = d;
        this._setk();
    }

    public ForceLayout(Graph<N, L> graph, Dimension dimension, int n, double d, double d2) {
        super(graph, dimension, n);
        this.temperature = d;
        this._setk();
    }

    private double attraction(double d) {
        return d * d / this.k;
    }

    private double repulsion(double d) {
        return this.k * this.k / d;
    }

    private double decay(double d) {
        return d * this.decay;
    }

    public ForceLayout<N, L> setMintemp(double d) {
        this.mintemp = d;
        return this;
    }

    public ForceLayout<N, L> setDecay(double d) {
        this.decay = d;
        return this;
    }

    public ForceLayout<N, L> setMinkve(double d) {
        this.minkve = d;
        return this;
    }

    public ForceLayout<N, L> setC(double d) {
        this.C = d;
        this._setk();
        return this;
    }

    public void setJiggle(double d) {
        this.jiggle = d;
    }

    @Override
    public boolean layout(float f) {
        double d = 0.0;
        double d2 = 0.0;
        Random random = new Random();
        debug.println("force-layout start");
        if (!super.layout(f)) {
            return false;
        }
        for (PositionableNode positionableNode : this.graph) {
            double d3;
            Vector2D vector2D;
            Vector2D vector2D2 = positionableNode.getVelocity();
            vector2D2.setLocation(0.0, 0.0);
            debug.printf("node: %s, pos: %s\n", positionableNode, positionableNode.getPosition());
            for (PositionableNode positionableNode2 : this.graph) {
                if (positionableNode2 == positionableNode) continue;
                if (positionableNode2.getPosition().distanceSq(positionableNode.getPosition()) <= 1.0) {
                    vector2D = new Vector2D(2.0, 0.0);
                    vector2D.rotate(random.nextInt(360));
                    positionableNode2.getPosition().plus(vector2D);
                }
                debug.printf("\trepulsion with %s, %s\n", positionableNode2, positionableNode2.getPosition());
                vector2D = new Vector2D(positionableNode.getPosition());
                vector2D.minus(positionableNode2.getPosition());
                debug.println("\t\tdelta1: " + vector2D);
                d3 = this.repulsion(vector2D.length());
                debug.println("\t\trepf: " + d3);
                vector2D.normalise();
                vector2D.times(d3);
                debug.println("\t\tdelta2: " + vector2D);
                vector2D2.plus(vector2D);
                debug.println("\tdisp after repf: " + vector2D2);
            }
            for (Edge edge : this.graph.edges(positionableNode)) {
                if (edge.to() == edge.from()) continue;
                debug.printf("\tattraction with %s\n", edge.to());
                vector2D = new Vector2D(positionableNode.getPosition());
                vector2D.minus(((PositionableNode)edge.to()).getPosition());
                debug.println("\t\tdelta1: " + vector2D + ", len " + vector2D.length());
                d3 = this.attraction(vector2D.length());
                debug.println("\t\tattrf: " + (d3 *= Math.max(0.0, random.nextGaussian()) * this.jiggle + 1.0));
                vector2D.normalise();
                vector2D.times(d3);
                debug.println("\t\tdelta2: " + vector2D);
                vector2D2.minus(vector2D);
                debug.println("\tdisp: " + vector2D2);
            }
            vector2D2.rotate(Math.toRadians(random.nextGaussian() / 3.0 * 10.0 * this.jiggle));
            debug.println("\tresultant v: " + vector2D2);
            Vector2D vector2D3 = positionableNode.getPosition();
            Vector2D object2 = positionableNode.getVelocity();
            debug.printf("node pos: %s\n", vector2D3);
            debug.printf("\tv: %s\n", object2);
            this.temperature = Math.max(this.decay(this.temperature), this.mintemp);
            object2.times((double)f * this.temperature);
            debug.printf("\tv2: %s\n", object2);
            vector2D3.plus(object2);
            debug.printf("\tp2: %s\n", vector2D3);
            vector2D3.x = Math.min(Math.max((double)(-this.bound.width / 2), vector2D3.x), (double)(this.bound.width / 2));
            vector2D3.y = Math.min(Math.max((double)(-this.bound.height / 2), vector2D3.y), (double)(this.bound.height / 2));
            double d4 = object2.magnitude();
            double d5 = (double)positionableNode.getMass() * d4 * d4;
            d += d5;
            d2 = Math.max(d2, d5);
            debug.println("\tresult: " + vector2D3);
        }
        debug.println("kve:    " + d);
        debug.println("maxkve: " + d2);
        return d > this.minkve;
    }
}

