#   Copyright (C) 2002 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


from tempfile import *
import tempfile
from popen2 import *
from os import *

class OBBCSoundTorturer:
    def __init__(self, filePrefix = mktemp()):
        self.fileName = filePrefix


    def CreateOrchestraFile(self, orchestra):
        self.inputText = ";;; Orchestra file"
        songInstrList = orchestra.Get()
        for i in songInstrList:
            self.inputText = self.inputText + "\n                instr " + str(i+1)
            self.inputText = self.inputText + "\n        asig    soundin     \"" + songInstrList[i] + "\""
            self.inputText = self.inputText + "\n        aout  = asig"
            self.inputText = self.inputText + """\n
                out         aout
                endin\n"""

        file(self.fileName + ".orc", 'w+').write(self.inputText)


    def CreateScoreFile(self, score, tempo):
        self.inputText = ";;; Score file\n;p1,    p2,     p3 "

        score.printScore()
        instrs = score.Get()
        for i in instrs:
            for j in instrs[i]:
                self.inputText = self.inputText + "\ni" + str(i+1) + "      " + str(j*1.0*tempo/1000) + "       " + str(tempo*1.0/1000)


        file(self.fileName + ".sco", 'w+').write(self.inputText)
        print self.inputText


    def createWaveFile(self):

        # TODO : plug a big random value in sufix
        targetWave = tempfile.mktemp()

        cmd = "csound -o '%s.wav' -W '%s.orc' '%s.sco' 2>/dev/null 1>&2"
        cmd = cmd  % ( targetWave, self.fileName, self.fileName )
        print cmd
        system(cmd)
        if access(targetWave + ".wav", R_OK):
            self.PurgeFiles()
            return targetWave + ".wav"
        else:
            raise Exception("wav file not found.")


    def PurgeFiles(self):
        if access(self.fileName + ".orc", R_OK):
            remove(self.fileName + ".orc")

        if access(self.fileName + ".sco", R_OK):
            remove(self.fileName + ".sco")

