/************************************************************************
 *                                                                      *
 * Open File Manager - ncurses file manager for GNU/Linux               *
 * (c) 2001, 2002 Slawomir Strumecki, Raphael Bugajewski                *
 *                                                                      *
 * This program is free software, you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 * If you want to contact us, please use the following address(es):     *
 *                                                                      *
 *     Raphael Bugajewski               Slawomir Strumecki              *
 *     Kl. Mittelstr. 1                 mailto: <logospam@poczta.fm>    *
 *     13585 Berlin / Germany                                           *
 *     Tel.: +49 (175) 331 93 92                                        *
 *     mailto: <born@bugajewski.de>                                     *
 *                                                                      *
 ************************************************************************/

#include "misc.h"
#include "menu.h"
#include <stdlib.h>
#include <string.h> /* strlen */

WINDOW *menubar=NULL;
char **mbar_names;
int mbar_len=0;

int menuBarCreate(char *names[])
{
    mbar_len=0;
    while(names[mbar_len]!=NULL) mbar_len++;
    menubar=newwin(1,COLS,0,0);
    if (menubar!=NULL) {
	wbkgd(menubar,COLOR_PAIR(2));	
	mbar_names=names;
    } else return (-1);
    return 0;
}

int menuBarRefresh(int sel)
{
    int i=0;

    werase(menubar);
    for (i=0;i<mbar_len;i++) {
	if (i==sel) wattron(menubar,COLOR_PAIR(13)|A_REVERSE);
	mvwprintw(menubar,0,i*12," %s ",mbar_names[i]);
	if (i==sel) wattroff(menubar,COLOR_PAIR(13)|A_REVERSE);
    }
    wrefresh(menubar);
    return 0;
}

int menuBarDelete()
{
    if (menubar!=NULL) delwin(menubar);
    return 0;
}

int menuPost(OMENU *om)
{
    if (om!=NULL && om->menu!=NULL) return (post_menu(om->menu)==E_OK);
    return 0;
}

int menuUnpost(OMENU *om)
{
    if (om!=NULL && om->menu!=NULL) return (unpost_menu(om->menu)==E_OK);
    return 0;
}

OMENU *menuCreate(int x, int y, char* names[], char* descs[])
{
    OMENU	*om;
    ITEM	**items;
    ITEM	*it;
    WINDOW	*my_menu_win;
    int 	menu_size=0;
    int 	menu_width=0;
    int		itmp,cit;

    om=NULL;
    while (names[menu_size]!=NULL) {
	itmp=strlen(names[menu_size])+strlen(descs[menu_size])+4;
	if (itmp>menu_width) menu_width=itmp;
	menu_size++;	/* quite dangerous */
    }
    om=(OMENU *)xmalloc(sizeof(OMENU));
    
    if (om!=NULL) {
	om->menu=NULL;
	om->items_count=menu_size;
	om->menu_width=menu_width;
	om->x=x;
	om->y=y;
	itmp=menu_size;
	items=NULL;
	items=(ITEM**)xmalloc(sizeof(ITEM)*itmp);
	if (items==NULL) return NULL;
	cit=0;
	itmp=0;
	
	while (itmp<menu_size) {
    	    it=new_item(names[itmp],descs[itmp]);
	    items[itmp]=NULL;
	    if (it!=NULL) {
		items[cit++]=it;
	    }
	    itmp++;
	}
	
	
	om->menu=new_menu(items);
	set_menu_fore(om->menu,COLOR_PAIR(13)|A_REVERSE);
	set_menu_back(om->menu,COLOR_PAIR(2));
	set_menu_grey(om->menu,COLOR_PAIR(3));
	set_menu_mark(om->menu,">");
	
	my_menu_win=newwin(menu_size+2,menu_width+1,y,x);
	wbkgd(my_menu_win,COLOR_PAIR(2));
	keypad(my_menu_win,TRUE);
	set_menu_win(om->menu,my_menu_win);
 	om->win=my_menu_win;
	om->subwin=derwin(my_menu_win,menu_size,menu_width,1,1);
	set_menu_win(om->menu,om->subwin);
    }
	
    return om;
}

int menuDelete(OMENU *om) 
{
    int tmp;
    ITEM **its;

    if (om!=NULL) {
	if (om->menu!=NULL) {
	    tmp=item_count(om->menu);
	    its=menu_items(om->menu);
	    while (tmp--) free_item(its[tmp]);
	    xfree(its);
	    free_menu(om->menu);
	}
	delwin(om->subwin);
	delwin(om->win);
	om->subwin=NULL;
	om->win=NULL;
	xfree(om);	
    }
    return 1;
}

int menuProcess(OMENU *om, int c)
{
    int result=0;
    
    if (om==NULL || om->menu==NULL) return -1;
    
    if (c==KEY_UP) menu_driver(om->menu,REQ_UP_ITEM);
    else if (c==KEY_DOWN)  menu_driver(om->menu,REQ_DOWN_ITEM);

    result = item_index(current_item(om->menu));
    return result;
}

int menuCurrentItem(OMENU *om)
{
    if (om!=NULL) {
	return item_index(current_item(om->menu));
    }
    return 0;
}
