/************************************************************************
 *                                                                      *
 * OFE - OFE ForEver - ncurses file editor for GNU/Linux                *
 * (c) 2001, 2002 Slawomir Strumecki, Raphael Bugajewski, Marcus vA     *
 *                                                                      *
 * This program is free software, you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 * If you want to contact us, please use the following address(es):     *
 *                                                                      *
 *     Raphael Bugajewski               Slawomir Strumecki              *
 *     Kl. Mittelstr. 1                 mailto: <logospam@poczta.fm>    *
 *     13585 Berlin / Germany                                           *
 *     Tel.: +49 (175) 331 93 92                                        *
 *     mailto: <born@bugajewski.de>                                     *
 *                                                                      *
 ************************************************************************/


/* for a linked list, we need such a struct, don't we? */
/* some typedefs for a better work and code display */
typedef struct _content content;
typedef content *contentPtr;

/**
 * _content, content, contentPtr:
 * 
 * a struct containing the text of the line, 
 + the line number and a pointer to the next
 + struct containing the next line
 *
 */

struct _content
{
  char* text;            /* the text from buf */
  int line_number;       /* line number */
  struct _content *next; /* ptr to next struct */
  struct _content *prev; /* ptr to previous struct */
};


typedef struct _first first;
typedef first *firstPtr;

/**
 * _first, first, firstPtr:
 *
 * a special struct for the first element of all,
 + it contains the lines and a pointer to the first 
 * line
 *
 */

struct _first
{
  int count;             /* how much lines */
  struct _content *head; /* the first one  */
};

/* returns the content of the file */
contentPtr
read_file (char *filename);

/* writes changes to the file */
void
write_file (char *filename);
