<?php
##############################################################
# FILENAME  : ladders.php
# COPYRIGHT : (c) 2006, Tyler N. King <aibotca@yahoo.ca>
# GPL v2.0 or later. See docs/COPYING.
##############################################################
# This program is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; 
# either version 2 of the License, or (at your option) 
# any later version.
#
# This program is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with this program; if not, write to the 
# Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
# Boston, MA  02110-1301  USA
##############################################################
define ( IN_PHPBB, true );
$phpbb_root_path	= './';

include ( $phpbb_root_path . 'includes/page_header.'.$phpEx );

if ( !$userdata[ 'session_logged_in' ] )
{
	message_die ( GENERAL_MESSAGE, $lang[ 'rivals_ltfin' ] );
}

$http_vars[ 'start' ]	= ( !empty ( $http_vars[ 'start' ] ) ) ? $http_vars[ 'start' ] : 0;
if ( !empty ( $http_vars[ 'rules' ] ) )
{
	$rules	= $ladder->data[ 'ladder_rules' ];
	if ( $board_config[ 'allow_bbcode' ] )
	{
		$rules_uid	= make_bbcode_uid ( );
		$rules		= bbencode_first_pass ( $rules, $rules_uid );
		$rules		= bbencode_second_pass ( $rules, $rules_uid );
		$rules		= smilies_pass ( $rules );
		$rules		= nl2br ( $rules );
	}

	message_die ( GENERAL_MESSAGE, $rules );
}

if ( !empty ( $http_vars[ 'platform' ] ) )
{
	if ( !empty ( $http_vars[ 'ladder_id' ] ) )
	{
		$sql		= 'SELECT count(*) AS total FROM ' . CLANS_TABLE . ' WHERE ladder_joined = ' . $http_vars[ 'ladder_id' ];
		$result	= $db->sql_query ( $sql );
 
		if ( $total = $db->sql_fetchrow ( $result ) ) 
		{ 
			$total_pag_items	= $total[ 'total' ]; 
			$pagination 		= generate_pagination ( 'rivals.php?action=ladders', $total_pag_items, $board_config[ 'topics_per_page' ], $http_vars[ 'start' ] );
		}

		$template->assign_block_vars ( 'block_clan', array (
			'PAGINATION' => $pagination, 
			'PAGE_NUMBER' => sprintf ( $lang[ 'Page_of' ], ( floor (  $start / $board_config[ 'topics_per_page' ] ) + 1 ), ceil (  $total_pag_items / $board_config[ 'topics_per_page' ] ) ),
			'L_SORTBY' => $lang[ 'rivals_sort' ],
			'S_CLANRATIO' => 'clan_ratio',
			'S_CLANSCORE' => 'clan_score',
			'L_CLANID' => $lang[ 'rivals_id' ],
			'L_CLANNAME' => $lang[ 'rivals_cnop' ],
			'L_CLANRATIO' => $lang[ 'rivals_rat' ],
			'L_CLANSCORE' => $lang[ 'rivals_sbs' ],
			'L_CLANWINS' => $lang[ 'rivals_opcw' ],
			'L_CLANLOSS' => $lang[ 'rivals_opcl' ],
			'L_CLANSTREAK' => $lang[ 'rivals_sop' ],
			'L_POS' => $lang[ 'rivals_pos' ] )
		);

		$sql	= 'SELECT * FROM ' . CLANS_TABLE . ' WHERE ladder_joined = "' . $http_vars[ 'ladder_id' ] . '" ORDER BY clan_score DESC LIMIT ' . $http_vars[ 'start' ] . ', ' . $board_config[ 'topics_per_page' ]; 
		$result	= $db->sql_query ( $sql );

		$cow	= $ladder->data ( 'ladder_rating', $http_vars[ 'ladder_id' ] );
		if ( !empty ( $cow ) )
		{
			$data	= array ( );
			for ( $i = 1; $i <= $db->sql_numrows ( $result ); $i++ )
			{
				$row	= $db->sql_fetchrow ( $result );

				$data[ ]	= array (
					'clan_id' => $row[ 'clan_id' ],
					'clan_name' => $row[ 'clan_name' ],
					'clan_win' => $row[ 'clan_win' ],
					'clan_loss' => $row[ 'clan_loss' ],
					'clan_score' => $row[ 'clan_score' ],
					'clan_streak' => $row[ 'clan_streak' ],
					'clan_rating' => ( $row[ 'clan_win' ] - $row[ 'clan_loss' ] ) + 100
				);
			}

			$new_data	= sort_by ( $data, 'clan_rating' );
			for ( $i = 0; $i < count ( $new_data ); $i++ )
			{
				if ( $new_data[ $i ][ 'clan_score' ] >= 0 )
				{
					$image	= $phpbb_root_path . 'images/rivals_up.png';
				}
				else
				{
					$image	= $phpbb_root_path . 'images/rivals_down.png';
				}

				$template->assign_block_vars ( 'block_clan.block_clans', array (
					'S_CLANNAME' => $new_data[ $i ][ 'clan_name' ],
					'S_CLANID' => $new_data[ $i ][ 'clan_id' ],
					'S_CLANWINS' => $new_data[ $i ][ 'clan_win' ],
					'S_ROWCOLOR' => ( $i % 2 ) ? 'row1' : 'row2',
					'U_ACTION' => append_sid ( 'rivals.php?action=view_clan&clan_id=' . $new_data[ $i ][ 'clan_id' ] ),
					'S_CLANLOSS' => $new_data[ $i ][ 'clan_loss' ],
					'S_CLANSCORE' => $new_data[ $i ][ 'clan_score' ],
					'S_CLANSTREAK' => $new_data[ $i ][ 'clan_streak' ],
					'I_UPODOWN' => $image,
					'S_POS' => $i + 1 )
				);
			}
		}
		else
		{
			for ( $i = 1; $i <= $db->sql_numrows ( $result ); $i++ )
			{
				$row	= $db->sql_fetchrow ( $result );

				if ( $clan->data ( 'clan_score', $row[ 'clan_id' ] ) >= 0 )
				{
					$image	= $phpbb_root_path . 'images/rivals_up.png';
				}
				else
				{
					$image	= $phpbb_root_path . 'images/rivals_down.png';
				}

				$template->assign_block_vars ( 'block_clan.block_clans', array (
					'S_CLANNAME' => $clan->data ( 'clan_name', $row[ 'clan_id' ] ),
					'S_CLANID' => $clan->data ( 'clan_id', $row[ 'clan_id' ] ),
					'S_CLANWINS' => $clan->data ( 'clan_win', $row[ 'clan_id' ] ),
					'S_ROWCOLOR' => ( $i % 2 ) ? 'row1' : 'row2',
					'U_ACTION' => append_sid ( 'rivals.php?action=view_clan&clan_id=' . $clan->data ( 'clan_id', $row[ 'clan_id' ] ) ),
					'S_CLANLOSS' => $clan->data ( 'clan_loss', $row[ 'clan_id' ] ),
					'S_CLANSCORE' => $clan->data ( 'clan_score', $row[ 'clan_id' ] ),
					'S_CLANSTREAK' => $clan->data ( 'clan_streak', $row[ 'clan_id' ] ),
					'I_UPODOWN' => $image,
					'S_POS' => $i )
				);
			}
		}
	}
	else
	{
		$template->assign_block_vars ( 'block_ladder', array (
			'L_LADDERNAME' => $lang[ 'rivals_lnop' ],
			'L_NUMCLANS' => $lang[ 'rivals_mo6' ] )
		);

		$sql	= 'SELECT * FROM ' . LADDERS_TABLE . ' WHERE (ladder_parent = "" OR ladder_parent = "0") AND platform = "' . $http_vars[ 'platform' ] . '" ORDER BY ladder_order ASC';
		$result	= $db->sql_query ( $sql );

		for ( $i = 0; $i < $db->sql_numrows ( $result ); $i++ )
		{
			$row	= $db->sql_fetchrow ( $result );

			$template->assign_block_vars ( 'block_ladder.block_ladders', array (
				'S_LADDERNAME' => $ladder->data ( 'ladder_name', $row[ 'ladder_id' ] ),
				'U_LADDERRULES' => append_sid ( 'rivals.php?action=ladders&rules=1&ladder_id=' . $ladder->data ( 'ladder_id', $row[ 'ladder_id' ] ) ) )
			);

			$sql_2		= 'SELECT * FROM ' . LADDERS_TABLE . ' WHERE ladder_parent = "' . $ladder->data ( 'ladder_id', $row[ 'ladder_id' ] ) . '" ORDER BY subladder_order ASC';
			$result_2	= $db->sql_query ( $sql_2 );

			for ( $x = 0; $x < $db->sql_numrows ( $result_2 ); $x++ )
			{
				$row_2	= $db->sql_fetchrow ( $result_2 );

				$sql_3		= 'SELECT count(*) AS num_clans FROM ' . CLANS_TABLE . ' WHERE ladder_joined = ' . $ladder->data ( 'ladder_id', $row_2[ 'ladder_id' ] );
				$result_3	= $db->sql_query ( $sql_3 );
				$row_3		= $db->sql_fetchrow ( $result_3 );

				$template->assign_block_vars ( 'block_ladder.block_ladders.block_subladders', array (
					'S_LADDERNAME' => $ladder->data ( 'ladder_name', $row_2[ 'ladder_id' ] ),
					'S_NUMCLANS' => $row_3[ 'num_clans' ],
					'U_ACTION' => append_sid ( 'rivals.php?action=ladders&platform=' . $http_vars[ 'platform' ] . '&ladder_id=' . $ladder->data ( 'ladder_id', $row_2[ 'ladder_id' ] ) ),
					'S_LADDERDESC' => $ladder->data ( 'ladder_desc', $row_2[ 'ladder_id' ] ) )
				);
			}
		}
	}
}
else
{
	$template->assign_block_vars ( 'block_platform', array (
		'L_PLATFORMS' => $lang[ 'rivals_pop' ],
		'L_PLATFORM' => $lang[ 'rivals_yiyb' ],
		'L_NUMLADDERS' => $lang['Ladders'],
		'L_PLATFORMDESC' => $lang[ 'rivals_yiyd' ] )
	);

	$sql	= 'SELECT * FROM ' . PLATFORMS_TABLE;
	$result	= $db->sql_query ( $sql );

	for ( $i = 1; $i <= $db->sql_numrows ( $result ); $i++ )
	{
		$row	= $db->sql_fetchrow ( $result );

		$sql_2		= 'SELECT count(*) AS num_ladders FROM ' . LADDERS_TABLE . ' WHERE platform = ' . $row[ 'platform_id' ];
		$result_2	= $db->sql_query ( $sql_2 );
		$row_2		= $db->sql_fetchrow ( $result_2 );

		$template->assign_block_vars ( 'block_platform.block_platforms', array (
			'S_ROWCOLOR' => ( $i % 2 ) ? 'row1' : 'row2',
			'S_COUNT' => $i,
			'S_NUMLADDERS' => $row_2[ 'num_ladders' ],
			'S_PLATFORMNAME' => $row[ 'platform_name' ],
			'U_ACTION' => append_sid ( 'rivals.php?action=ladders&platform=' . $row[ 'platform_id' ] ) )
		);
	}
}

$template->set_filenames ( array (
	'body' => 'rivals/ls_mode1.tpl' )
);

$template->pparse ( 'body' );

include ( $phpbb_root_path . 'includes/page_tail.'.$phpEx );

?>
