<?php
##############################################################
# FILENAME  : report_match.php
# COPYRIGHT : (c) 2006, Tyler N. King <aibotca@yahoo.ca>
# GPL v2.0 or later. See docs/COPYING.
##############################################################
# This program is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; 
# either version 2 of the License, or (at your option) 
# any later version.
#
# This program is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with this program; if not, write to the 
# Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
# Boston, MA  02110-1301  USA
##############################################################
define ( IN_PHPBB, true );
$phpbb_root_path	= './';

include ( $phpbb_root_path . 'includes/page_header.'.$phpEx );

if ( !$userdata[ 'session_logged_in' ] )
{
	message_die ( GENERAL_MESSAGE, $lang[ 'rivals_ltfin' ] );
}

if ( !empty ( $http_vars[ 'submit_2' ] ) )
{
	if ( !empty ( $http_vars[ 'quick_clan' ] ) )
	{
		$date	= date ( 'd.m.y' );
		$sql	= 'INSERT INTO ' . CHALLENGES_TABLE . ' (challenge_id, challenge_time, challenge_status, challenge_winner, challenger, challengee) VALUES ("NULL", "' . $date . '", "3", "' . $http_vars[ 'quick_clan' ] . '", "' . $http_vars[ 'quick_clan' ] . '", "' . $clan->data[ 'clan_id' ] . '")';
		$db->sql_query ( $sql );

		$sql	= 'UPDATE ' . CLANS_TABLE . ' SET clan_win = clan_win + "1", clan_score = clan_score + "2", clan_streak = clan_streak + "1" WHERE clan_id = ' . $http_vars[ 'quick_clan' ];
		$db->sql_query ( $sql );

		$sql	= 'UPDATE ' . CLANS_TABLE . ' SET clan_loss = clan_loss + "1", clan_score = clan_score + "0", clan_streak = clan_streak - "1" WHERE clan_id = ' . $clan->data[ 'clan_id' ];
		$db->sql_query ( $sql );

		insert_pm ( $clan->data[ 'clan_owner' ], sprintf ( $lang[ 'rivals_quik' ], $clan->data ( 'clan_name', $http_vars[ 'quick_clan' ] ), $clan->data[ 'clan_name' ] ), $lang[ 'rivals_pmmr' ], $clan->data ( 'clan_owner', $http_vars[ 'quick_clan' ] ) );
		insert_pm ( $clan->data ( 'clan_owner', $http_vars[ 'quick_clan' ] ), sprintf ( $lang[ 'rivals_quik' ], $clan->data ( 'clan_name', $http_vars[ 'quick_clan' ] ), $clan->data[ 'clan_name' ] ), $lang[ 'rivals_pmmr' ], $clan->data[ 'clan_id' ] );

		message_die ( GENERAL_MESSAGE, $lang[ 'rivals_wls' ] );
	}

	$sql			= 'SELECT * FROM ' . CHALLENGES_TABLE . ' WHERE challenge_status = "2" AND challenge_id = ' . $http_vars[ 'challenge_id' ];
	$result			= $db->sql_query ( $sql );
	$row			= $db->sql_fetchrow ( $result );

	if ( $http_vars[ 'type' ] == '1' )
	{
		if ( !empty ( $row[ 'challenge_winner' ] ) )
		{
			message_die ( GENERAL_ERROR, $lang[ 'rivals_war' ] );
		}

		if ( $row[ 'challenger' ] == $clan->data[ 'clan_id' ] )
		{
			$opp	= $row[ 'challengee' ];
			$field	= explode ( '|', 'c|win|winner|+' );
		}
		else if ( $row[ 'challengee' ] == $clan->data[ 'clan_id' ] )
		{
			$opp	= $row[ 'challenger' ];
			$field	= explode ( '|', 'ce|win|winner|+' );
		}
		else
		{
			message_die ( GENERAL_ERROR, $lang[ 'rivals_coce' ] );
		}
	}
	else
	{
		if ( !empty ( $row[ 'challenge_looser' ] ) )
		{
			message_die ( GENERAL_ERROR, $lang[ 'rivals_war' ] );
		}

		if ( $row[ 'challenger' ] == $clan->data[ 'clan_id' ] )
		{
			$opp	= $row[ 'challengee' ];
			$field	= explode ( '|', 'c|loss|looser|-' );
		}
		else if ( $row[ 'challengee' ] == $clan->data[ 'clan_id' ] )
		{
			$opp	= $row[ 'challenger' ];
			$field	= explode ( '|', 'ce|loss|looser|-' );
		}
		else
		{
			message_die ( GENERAL_ERROR, $lang[ 'rivals_coce' ] );
		}
	}

	$round_string	= '';
	$clan_score		= '';
	$rounds_won		= 0;
	$rounds_loss	= 0;
	$i				= 0;

	foreach ( $http_vars[ 'kerbe' ] AS $round_score )
	{
		if ( $http_vars[ 'won_rounds' ][ $i ] == '1' )
		{
			$rounds_won	+= 1;
		}
		else
		{
			$rounds_loss	+= 1;
		}

		$round_string	.= $i . '|' . $round_score;
		$clan_score		= $round_score + $clan_score; $i++;
	}

	if ( !empty ( $http_vars[ 'optional_on' ] ) )
	{
		$i	= 0;
		foreach ( $http_vars[ 'kerbe_user' ] AS $member )
		{
			$sql_3		= 'SELECT * ' . USERS_TABLE . ' WHERE user_id = ' . $member;
			$result_3	= $db->sql_query ( $sql );
			$row_3		= $db->sql_fetchrow ( $result_3 );

			if ( strstr ( $row_3[ 'user_stats' ], $clan->data[ 'clan_id' ] . '(f1)' ) )
			{
				$explode_2	= explode ( '|', $row_3[ 'user_stats' ] );
				foreach ( $explode_2 AS $stats )
				{
					$explode_3	= explode ( ':', $stats );
					foreach ( $explode_3 AS $f )
					{
						if ( strstr ( $explode_3[ 0 ], $clan->data[ 'clan_id' ] . '(f1)' ) )
						{
							$new_f1		= $explode_3[ 1 ] + $http_vars[ 'kerbe_f1' ][ $i ];
							$new		= str_replace ( $clan->data[ 'clan_id' ] . '(f1):' . $explode_3[ 1 ], $clan->data[ 'clan_id' ] . '(f1):' . $new_f1, $row_3[ 'user_stats' ] );

							$sql_4		= 'UPDATE ' . USERS_TABLE . ' SET user_stats = "' . $new . '" WHERE user_id = ' . $member;
							$db->sql_query ( $sql_4 );
						}
						else if ( strstr ( $explode_3[ 0 ], $clan->data[ 'clan_id' ] . '(f2)' ) )
						{
							$new_f2		= $explode_3[ 1 ] + $http_vars[ 'kerbe_f2' ][ $i ];
							$new		= str_replace ( $clan->data[ 'clan_id' ] . '(f2):' . $explode_3[ 1 ], $clan->data[ 'clan_id' ] . '(f2):' . $new_f2, $row_3[ 'user_stats' ] );

							$sql_4		= 'UPDATE ' . USERS_TABLE . ' SET user_stats = "' . $new . '" WHERE user_id = ' . $member;
							$db->sql_query ( $sql_4 );
						}
						else
						{
							continue;
						}
					}
				}
			}
			else
			{
				$f1_data	= ( !empty ( $http_vars[ 'kerbe_f1' ][ $i ] ) ) ? $http_vars[ 'kerbe_f1' ][ $i ] : 0;
				$f1			= '|' . $clan->data[ 'clan_id' ] . '(f1)' . ':' . $f1_data;
				$f2_data	= ( !empty ( $http_vars[ 'kerbe_f2' ][ $i ] ) ) ? $http_vars[ 'kerbe_f2' ][ $i ] : 0;
				$f2			= '|' . $clan->data[ 'clan_id' ] . '(f2)' . ':' . $f2_data;

				$all		= $row_3[ 'user_data' ] . $f1 . $f2;
				$sql_4		= 'UPDATE ' . USERS_TABLE . ' SET user_stats = "' . $all . '" WHERE user_id = ' . $member;
				$db->sql_query ( $sql_4 );
			}

			$i++;
		}
	}

	$sql	= 'UPDATE ' . CHALLENGES_TABLE . ' SET ' . $field[ 0 ] . '_rounds = "' . $round_string . '", ' . $field[ 0 ] . '_wrounds = "' . $rounds_won . '", ' . $field[ 0 ] . '_lrounds = "' . $rounds_loss . '", challenge_' . $field[ 2 ] . ' = "' . $clan->data[ 'clan_id' ] . '" WHERE challenge_id = ' . $http_vars[ 'challenge_id' ];
	$db->sql_query ( $sql );

	if ( $ladder->data ( 'ladder_scoring', $clan->data[ 'ladder_joined' ] ) == '0' || $ladder->data ( 'ladder_scoring', $clan->data[ 'ladder_joined' ] ) == '' )
	{
		$sql	= 'UPDATE ' . CLANS_TABLE . ' SET clan_' . $field[ 1 ] . ' = clan_' . $field[ 1 ] . ' + "1", clan_score = clan_score ' . $field[ 3 ] . ' "' . $clan_score . '", clan_wrounds = clan_wrounds + "' . $rounds_won . '", clan_lrounds = clan_lrounds + "' . $rounds_loss . '", clan_streak = clan_streak ' . $field[ 3 ] . ' "1" WHERE clan_id = ' . $clan->data[ 'clan_id' ];
		$db->sql_query ( $sql );
	}
	else
	{
		if ( $http_vars[ 'type' ] == '1' )
		{
			$string	= '+ "2"';
		}
		else
		{
			$string	= '+ "0"';
		}

		$sql	= 'UPDATE ' . CLANS_TABLE . ' SET clan_' . $field[ 1 ] . ' = clan_' . $field[ 1 ] . ' + "1", clan_score = clan_score ' . $string . ', clan_wrounds = clan_wrounds + "' . $rounds_won . '", clan_lrounds = clan_lrounds + "' . $rounds_loss . '", clan_streak = clan_streak ' . $field[ 3 ] . ' "1" WHERE clan_id = ' . $clan->data[ 'clan_id' ];
		$db->sql_query ( $sql );
	}

	$sql		= 'SELECT * FROM ' . CHALLENGES_TABLE . ' WHERE challenge_status = "2" AND challenge_id = ' . $http_vars[ 'challenge_id' ];
	$result	= $db->sql_query ( $sql );
	$chall		= $db->sql_fetchrow ( $result );

	if ( !empty ( $chall[ 'c_rounds' ] ) && !empty ( $chall[ 'ce_rounds' ] ) )
	{
		$sql		= 'SELECT * FROM ' . CLANS_TABLE . ' WHERE clan_id = ' . $opp;
		$result	= $db->sql_query ( $sql );
		$row		= $db->sql_fetchrow ( $result );
		$clan_owner	= $row[ 'clan_owner' ];
		$clan_name	= $row[ 'clan_name' ];

		$clan_owner2	= $clan->data[ 'clan_owner' ];
		$clan_name2		= $clan->data[ 'clan_name' ];

		$pm_string	= '';
		foreach ( explode ( '|', $chall[ 'c_rounds' ] ) AS $score )
		{
			$explode	= explode ( ':', $score );
			$pm_string	.= $lang[ 'rivals_round' ] . ' ' . $explode[ 0 ] . ': ' . $explode[ 1 ];
		}

		$pm_string2	= '';
		foreach ( explode ( '|', $chall[ 'ce_rounds' ] ) AS $score )
		{
				$explode	= explode ( ':', $score );
				$pm_string2	.= $lang[ 'rivals_round' ] . ' ' . $explode[ 0 ] . ': ' . $explode[ 1 ];
		}

		$sql	= 'UPDATE ' . CHALLENGES_TABLE . ' SET challenge_status = "3", challenge_time = "' . date ( 'd.m.y' ) . '" WHERE challenge_id = ' . $http_vars[ 'challenge_id' ];
		$db->sql_query ( $sql );

		insert_pm ( $clan_owner, sprintf ( $lang[ 'rivals_pmmrb' ], $http_vars[ 'challenge_id' ], date ( 'm.d.y' ), $clan_name, $pm_string, $chall[ 'c_wrounds' ], $chall[ 'c_lrounds' ], $clan_name2, $pm_string2, $chall[ 'ce_wrounds' ], $chall[ 'ce_lrounds' ], $chall[ 'challenge_winner' ], $chall[ 'challenge_looser' ] ), $lang[ 'rivals_pmmr' ], $clan_owner2 );
		insert_pm ( $clan_owner2, sprintf ( $lang[ 'rivals_pmmrb' ], $http_vars[ 'challenge_id' ], date ( 'm.d.y' ), $clan_name, $pm_string, $chall[ 'c_wrounds' ], $chall[ 'c_lrounds' ], $clan_name2, $pm_string2, $chall[ 'ce_wrounds' ], $chall[ 'ce_lrounds' ], $chall[ 'challenge_winner' ], $chall[ 'challenge_looser' ] ), $lang[ 'rivals_pmmr' ], $clan_owner2 );
	}

	message_die ( GENERAL_MESSAGE, $lang[ 'rivals_wls' ] );
}
else
{
	if ( !empty ( $http_vars[ 'quick' ] ) )
	{
		$sql		= 'SELECT * FROM ' . CLANS_TABLE . ' WHERE clan_owner != ' . $userdata[ 'user_id' ];
		$result	= $db->sql_query ( $sql );

		for ( $i = 0; $i < $db->sql_numrows ( $result ); $i++ )
		{
			$row	= $db->sql_fetchrow ( $result );

			$sql_3		= 'SELECT * FROM ' . LADDERS_TABLE . ' WHERE ladder_id = ' . $row[ 'ladder_joined' ];
			$result_3	= $db->sql_query ( $sql_3 );
			$row_3		= $db->sql_fetchrow ( $result_3 );
			$sub		= $row_3[ 'ladder_name' ];

			$sql_4		= 'SELECT * FROM ' . LADDERS_TABLE . ' WHERE ladder_id = ' . $row_3[ 'ladder_parent' ];
			$result_4	= $db->sql_query ( $sql_4 );
			$row_4		= $db->sql_fetchrow ( $result_4 );
			$ladder		= $row_4[ 'ladder_name' ];

			$sql_5		= 'SELECT * FROM ' . PLATFORMS_TABLE . ' WHERE platform_id = ' . $row_4[ 'platform' ];
			$result_5	= $db->sql_query ( $sql_5 );
			$row_5		= $db->sql_fetchrow ( $result_5 );
			$platform	= $row_5[ 'platform_name' ];

			$template->assign_block_vars ( 'block_clans', array (
				'S_CLANID' => $row[ 'clan_id' ],
				'S_CLANNAME' => $row[ 'clan_name' ],
				'S_CLANLADDER' => $ladder,
				'S_CLANPLATFORM' => $platform,
				'S_CLANSUB' => $sub )
			);
		}

		$template->assign_vars ( array (
			'L_QUICK' => $lang[ 'rivals_qor' ],
			'L_SUBMIT' => $lang[ 'rivals_1x1s' ],
			'L_RIVALS_CMH' => $lang[ 'rivals_cmh' ] )
		);

		$template->set_filenames ( array (
			'body' => 'rivals/cs_mode1-sub.tpl' )
		);

		$template->pparse ( 'body' );
	}
	else
	{
		$sql			= 'SELECT * FROM ' . CHALLENGES_TABLE . ' WHERE challenge_status = "2" AND challenge_id = ' . $http_vars[ 'challenge_id' ];
		$result		= $db->sql_query ( $sql );
		$row			= $db->sql_fetchrow ( $result );

		for ( $i = 0; $i < $row[ 'challenge_rounds' ]; $i++ )
		{
			$template->assign_block_vars ( 'block_rounds', array (
				'L_ROUND' => $lang[ 'rivals_round' ],
				'S_ROUND' => $i + 1 )
			);
		}

		$explode	= explode ( '|', $clan->data[ 'clan_members' ] );
		foreach ( $explode AS $member )
		{
			$sql_2		= 'SELECT * FROM ' . USERS_TABLE . ' WHERE user_id = ' . $member;
			$result_2	= $db->sql_query ( $sql_2 );
			$row_2		= $db->sql_fetchrow ( $sql_3 );

			$template->assign_block_vars ( 'block_members', array (
				'S_USERID' => $row_2[ 'user_id' ],
				'S_USERNAME' => $row_2[ 'username' ] )
			);
		}

		$sql_3		= 'SELECT * FROM ' . LADDERS_TABLE . ' WHERE ladder_id = ' . $clan->data[ 'ladder_joined' ];
		$result_3	= $db->sql_query ( $sql_3 );
		$row_3		= $db->sql_fetchrow ( $result_3 );

		$template->assign_vars ( array (
			'U_ACTION' => 'rivals.php?action=report_match',
			'L_REPORT' => $lang[ 'rivals_prc' ],
			'L_OPTIONAL' => $lang[ 'rivals_ihbhd' ],
			'S_ROUNDS' => $row[ 'challenge_rounds' ],
			'S_TYPE' => $http_vars[ 'type' ],
			'S_F1' => $row_3[ 'ladder_f1' ],
			'S_F2' => $row_3[ 'ladder_f2' ],
			'S_CHALLENGEID' => $http_vars[ 'challenge_id' ] )
		);

		$template->set_filenames ( array (
			'body' => 'rivals/cs_mode1.tpl' )
		);

		$template->pparse ( 'body' );
	}
}

include ( $phpbb_root_path . 'includes/page_tail.'.$phpEx );

?>
