<?php
##############################################################
# FILENAME  : rivals_source.php
# COPYRIGHT : (c) 2006, Tyler N. King <aibotca@yahoo.ca>
# GPL v2.0 or later. See docs/COPYING.
##############################################################
# This program is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; 
# either version 2 of the License, or (at your option) 
# any later version.
#
# This program is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with this program; if not, write to the 
# Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
# Boston, MA  02110-1301  USA
##############################################################
define ( 'CLANS_TABLE', $table_prefix . 'clans' );
define ( 'CHALLENGES_TABLE', $table_prefix . 'challenges' );
define ( 'LADDERS_TABLE', $table_prefix . 'ladders' );
define ( 'PLATFORMS_TABLE', $table_prefix . 'platforms' );
define ( 'RIVALS_CONFIG', $table_prefix . 'rivalsconfig' );
define ( 'TOURNAMENTS_TABLE', $table_prefix . 'tournaments' );
define ( 'SPONSORS_TABLE', $table_prefix . 'sponsors' );
define ( 'INVITES_TABLE', $table_prefix . 'invites' );

// From php.net 
function sort_by ( $array,  $keyname = null )
{
 	$myarray	= $inarray	= array ( );   

	foreach ( $array AS $i => $befree )
	{
		$myarray[ $i ]	= $array[ $i ][ $keyname ];
	}

	asort ( $myarray );

	foreach ( $myarray AS $key => $befree )
	{
       $inarray[ $key ]	= $array[ $key ];
	}

	return array_reverse ( $inarray );
}

// Antispam by Ramon Fincken.
function group_check ( $user_id, $group_id )
{
	global $db;

	$sql	= 'SELECT user_id FROM ' . USER_GROUP_TABLE . ' WHERE user_id = ' . intval ( $user_id ) . ' AND user_pending = 0 AND ((group_id = ' . intval ( $group_id ) . ') )  LIMIT 1';
	if ( ! ( $result = $db->sql_query ( $sql ) ) )
	{
		message_die ( GENERAL_ERROR, 'Could not obtain group information for this user', '', __LINE__, __FILE__, $sql );
	}

	$ok	= false;
	while ( $group_data = $db->sql_fetchrow ( $result ) )
	{
		$ok	= true;
	}

	return $ok;
}  

// Antispam by Ramon Fincken.
function has_spamstatus ( $word, $text )
{
	$spam_status	= false;
	if ( preg_match ( "#\b(" . str_replace ( "\*", ".*?", preg_quote ( $word, '#' ) ) . ")\b#i", $text ) ) 
	{
		 $spam_status	= true;
	}

	return $spam_status;
}

// Antispam by Ramon Fincken.
function validate_spam ( $text, $website = false )
{
	global $db, $userdata;

	$sql		= 'SELECT * FROM ' . GROUPS_TABLE . ' WHERE group_name = "ByPass Words"';
	$result		= $db->sql_query ( $sql );
	$row		= $db->sql_fetchrow ( $result );
	$group_id	= $row[ 'group_id' ];

	if ( $website != false )
	{
		$regex	= array (
			'#([a-zA-Z0-9][a-zA-Z0-9-]*\.)+(arpa|root|aero|biz|cat|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|net|org|pro|travel|ac|ad|ae|af|ag|ai|al|am|an|ao|aq|ar|as|at|au|aw|ax|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|cr|cu|cv|cx|cy|cz|de|dj|dk|dm|do|dz|ec|ee|eg|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|uk|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|in|io|iq|ir|is|it|je|jm|jo|jp|ke|kg|kh|ki|km|kn|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|mg|mh|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|re|ro|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|sk|sl|sm|sn|so|sr|st|su|sv|sy|sz|tc|td|tf|tg|th|tj|tk|tl|tm|tn|to|tp|tr|tt|tv|tw|tz|ua|ug|uk|um|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|yu|za|zm|zw)#is'
		);
		$urls	= array ( );

		while ( list ( $key, $value ) = @each ( $regex ) )
		{
			preg_match_all ( $value, $text, $result );
			$urls[ ]	= $result;
		}

		$found	= array ( );
		while ( list ( $key, $value ) = @each ( $urls ) )
		{
			while ( list ( $key_2, $value_2 ) = @each ( $value ) )
			{
				while ( list ( $key_3, $value_3 ) = @each ( $value_2 ) )
				{
					if ( strlen ( $value_3 ) > 3 )
					{
						if ( !in_array ( $value_3, $found ) )
						{
							$found[ ]	= trim ( $value_3 );
						}
					}
				}
			}
		}

		foreach ( $found AS $key => $value )
		{
			$handle		= @fopen ( $value, 'rb' );
			$contents	= '';
			while ( !@feof ( $handle ) )
			{
				$contents	.= @fread ( $handle, 8192 );
			}

			@fclose ( $handle );

			if ( strlen ( $contents ) > 10 )
			{ 
				validate_spam ( $contents );
			}
		}
	}

	$spam_exp	= $lang[ 'rbypass_words' ];

	$sql	= 'SELECT word FROM ' . WORDS_TABLE;
	if ( $result = $db->sql_query ( $sql ) )
	{
		if ( $row = $db->sql_fetchrow ( $result ) )
		{
			if ( has_spamstatus ( $row[ 'word' ], $text ) )
			{                               
				$db->sql_freeresult ( $result );

				if ( $userdata[ 'user_level' ] == ADMIN || $userdata[ 'user_level' ] == MOD )
				{
					message_die ( GENERAL_ERROR,  '<b>Usage of forbidden word</b><br />' . $spam_exp . '<br /><br />' . $row[ 'word' ] . '<br />' . $text );
				}
				else
				{
					if ( group_check ( $userdata[ 'user_id' ], $group_id ) == false )
					{
						message_die ( GENERAL_ERROR,  '<b>Usage of forbidden word</b><br />' . $spam_exp . '<br /><br />' . $text );
					}
				}
			}
		}
	}

	$db->sql_freeresult ( $result );
	return true;
}

// From phpBB core
function re_order ( $move, $ladder_id )
{
	global $db;

	if ( $move == 'up' )
	{
		$move	= '-15';
	}
	else
	{
		$move	= '15';
	}

	$sql	= 'SELECT * FROM ' . LADDERS_TABLE . ' WHERE ladder_id = ' . $ladder_id;
	$result	= $db->sql_query ( $sql );
	$row	= $db->sql_fetchrow ( $result );

	if ( $row[ 'ladder_parent' ] == '' || $row[ 'ladder_parent' ] == '0' )
	{
		$field	= 'ladder_order';
	}
	else
	{
		$field	= 'subladder_order';
	}

	$sql	= 'UPDATE ' . LADDERS_TABLE . ' SET ' . $field . ' = ' . $field . ' + $move WHERE ladder_id = ' . $ladder_id;
	$result	= $db->sql_query ( $sql );

	$sql	= 'SELECT * FROM ' . LADDERS_TABLE . ' ORDER BY ' . $field . ' ASC';
	$result	= $db->sql_query ( $sql );

	$i = 10;
	while ( $row = $db->sql_fetchrow ( $result ) )
	{
		$sql	= 'UPDATE ' . LADDERS_TABLE . ' SET ' . $field . ' = ' . $i . ' WHERE ladder_id = ' . $row[ 'ladder_id' ];
		$db->sql_query ( $sql );

		$i	+= 10;
	}
}

function in_multi_array ( $needle, $haystack, $strict = '' )
{ 
	if ( $strict )
	{ 
		foreach ( $haystack AS $item )
		{ 
			if ( is_array ( $item ) )
			{ 
				if ( in_multi_array ( $needle, $item, $strict ) )
				{ 
					return true; 
				} 
			}
			else
			{ 
				if ( $needle === $item )
				{ 
					return true; 
				} 
			} 
		} 
	}
	else
	{ 
		foreach ( $haystack AS $item )
		{ 
			if (is_array ( $item ) )
			{ 
				if ( in_multi_array ( $needle, $item, $strict ) )
				{ 
					return true; 
				} 
			}
			else
			{ 
				if ( $needle == $item )
				{ 
					return true; 
				} 
			} 
		} 
	}

	return false; 
}

function multi_unique ( $array )
{
	foreach ( $array AS $k => $na )
	{
		$new[ $k ]	= serialize ( $na );
	}

	$uniq		= array_unique ( $new );
	foreach ( $uniq AS $k => $ser )
	{
		$new1[ $k ]	= unserialize ( $ser );
	}

	return $new1;
}

// wGeric's Insert_PM()
function insert_pm( 
     $to_id, 
     $message, 
     $subject, 
     $from_id, 
     $attach_sig = 0, 
     $html_on = 0, 
     $bbcode_on = 1, 
     $smilies_on = 1) 
 { 
     global $board_config, $db, $emailer, $html_entities_match, $html_entities_replace, $lang, $phpbb_root_path, $phpEx, $unhtml_specialchars_match, $unhtml_specialchars_replace, $user_ip, $userdata;

     include_once($phpbb_root_path . 'includes/bbcode.'.$phpEx); 
     include_once($phpbb_root_path . 'includes/functions_post.'.$phpEx); 
 
     if ( !$from_id ) 
     { 
         $from_id = $userdata['user_id']; 
     } 
 
     //get varibles ready 
     $to_id = intval($to_id); 
     $from_id = intval($from_id); 
     $msg_time = time(); 
     $attach_sig = ($attach_sig == 0) ? 0 : $userdata['user_attachsig']; 
     
     //get to users info 
     $sql = "SELECT user_id, user_notify_pm, user_email, user_lang, user_active 
             FROM " . USERS_TABLE . " 
             WHERE user_id = '$to_id' 
             AND user_id <> " . ANONYMOUS; 
     if ( !($result = $db->sql_query($sql)) ) 
     { 
         $error = TRUE; 
         $error_msg = $lang['No_such_user']; 
     } 
 
     $to_userdata = $db->sql_fetchrow($result); 
 
     $privmsg_subject = trim(strip_tags($subject)); 
     if ( empty($privmsg_subject) ) 
     { 
         $error = TRUE; 
         $error_msg .= ( ( !empty($error_msg) ) ? '<br />' : '' ) . $lang['Empty_subject']; 
     } 
 
     if ( !empty($message) ) 
     { 
         if ( !$error ) 
         { 
             if ( $bbcode_on ) 
             { 
                 $bbcode_uid = make_bbcode_uid(); 
             } 
 
             $privmsg_message = prepare_message($message, $html_on, $bbcode_on, $smilies_on, $bbcode_uid); 
             $privmsg_message = str_replace('\\\n', '\n', $privmsg_message); 
 
         } 
     } 
     else 
     { 
         $error = TRUE; 
         $error_msg .= ( ( !empty($error_msg) ) ? '<br />' : '' ) . $lang['Empty_message']; 
     } 
 
     // 
     // See if recipient is at their inbox limit 
     // 
     $sql = "SELECT COUNT(privmsgs_id) AS inbox_items, MIN(privmsgs_date) AS oldest_post_time 
             FROM " . PRIVMSGS_TABLE . " 
             WHERE ( privmsgs_type = " . PRIVMSGS_NEW_MAIL . " 
                     OR privmsgs_type = " . PRIVMSGS_READ_MAIL . " 
                     OR privmsgs_type = " . PRIVMSGS_UNREAD_MAIL . " ) 
                 AND privmsgs_to_userid = " . $to_userdata['user_id']; 
     if ( !($result = $db->sql_query($sql)) ) 
     { 
         message_die(GENERAL_MESSAGE, $lang['No_such_user']); 
     } 
 
     $sql_priority = ( SQL_LAYER == 'mysql' ) ? 'LOW_PRIORITY' : ''; 
 
     if ( $inbox_info = $db->sql_fetchrow($result) ) 
     { 
         if ( $inbox_info['inbox_items'] >= $board_config['max_inbox_privmsgs'] ) 
         { 
             $sql = "SELECT privmsgs_id FROM " . PRIVMSGS_TABLE . " 
                     WHERE ( privmsgs_type = " . PRIVMSGS_NEW_MAIL . " 
                             OR privmsgs_type = " . PRIVMSGS_READ_MAIL . " 
                             OR privmsgs_type = " . PRIVMSGS_UNREAD_MAIL . "  ) 
                         AND privmsgs_date = " . $inbox_info['oldest_post_time'] . " 
                         AND privmsgs_to_userid = " . $to_userdata['user_id']; 
             if ( !$result = $db->sql_query($sql) ) 
             { 
                 message_die(GENERAL_ERROR, $lang['No_find_oldest_privmsgs'], '', __LINE__, __FILE__, $sql); 
             } 
             $old_privmsgs_id = $db->sql_fetchrow($result); 
             $old_privmsgs_id = $old_privmsgs_id['privmsgs_id']; 
 
             $sql = "DELETE $sql_priority FROM " . PRIVMSGS_TABLE . " 
                     WHERE privmsgs_id = $old_privmsgs_id"; 
             if ( !$db->sql_query($sql) ) 
             { 
                 message_die(GENERAL_ERROR, $lang['No_delete_oldest_privmsgs'].$sql, '', __LINE__, __FILE__, $sql); 
             } 
 
             $sql = "DELETE $sql_priority FROM " . PRIVMSGS_TEXT_TABLE . " 
                     WHERE privmsgs_text_id = $old_privmsgs_id"; 
             if ( !$db->sql_query($sql) ) 
             { 
                 message_die(GENERAL_ERROR, $lang['No_delete_oldest_privmsgs_text'], '', __LINE__, __FILE__, $sql); 
             } 
         } 
     } 
 
     $sql_info = "INSERT INTO " . PRIVMSGS_TABLE . " (privmsgs_type, privmsgs_subject, privmsgs_from_userid, privmsgs_to_userid, privmsgs_date, privmsgs_ip, privmsgs_enable_html, privmsgs_enable_bbcode, privmsgs_enable_smilies, privmsgs_attach_sig) 
                 VALUES (" . PRIVMSGS_NEW_MAIL . ", '" . str_replace("\'", "''", $privmsg_subject) . "', " . $from_id . ", " . $to_userdata['user_id'] . ", $msg_time, '$user_ip', $html_on, $bbcode_on, $smilies_on, $attach_sig)"; 
 
     if ( !($result = $db->sql_query($sql_info, BEGIN_TRANSACTION)) ) 
     { 
         message_die(GENERAL_ERROR, $lang['No_PM_sent_info'], "", __LINE__, __FILE__, $sql_info); 
     } 
 
     $privmsg_sent_id = $db->sql_nextid(); 
 
     $sql = "INSERT INTO " . PRIVMSGS_TEXT_TABLE . " (privmsgs_text_id, privmsgs_bbcode_uid, privmsgs_text) 
             VALUES ($privmsg_sent_id, '" . $bbcode_uid . "', '" . str_replace("\'", "''", $privmsg_message) . "')"; 
 
     if ( !$db->sql_query($sql, END_TRANSACTION) ) 
     { 
         message_die(GENERAL_ERROR, $lang['No_PM_sent_text'], "", __LINE__, __FILE__, $sql); 
     } 
 
     // 
     // Add to the users new pm counter 
     // 
     $sql = "UPDATE " . USERS_TABLE . " 
             SET user_new_privmsg = user_new_privmsg + 1, user_last_privmsg = " . time() . " 
             WHERE user_id = " . $to_userdata['user_id']; 
     if ( !$status = $db->sql_query($sql) ) 
     { 
         message_die(GENERAL_ERROR, $lang['No_PM_read_status'], '', __LINE__, __FILE__, $sql); 
     } 
 
     if ( $to_userdata['user_notify_pm'] && !empty($to_userdata['user_email']) && $to_userdata['user_active'] ) 
     { 
         $script_name = preg_replace('/^\/?(.*?)\/?$/', "\\1", trim($board_config['script_path'])); 
         $script_name = ( $script_name != '' ) ? $script_name . '/privmsg.'.$phpEx : 'privmsg.'.$phpEx; 
         $server_name = trim($board_config['server_name']); 
         $server_protocol = ( $board_config['cookie_secure'] ) ? 'https://' : 'http://'; 
         $server_port = ( $board_config['server_port'] <> 80 ) ? ':' . trim($board_config['server_port']) . '/' : '/'; 
 
         if ( !class_exists('emailer') ) 
         { 
             include($phpbb_root_path . 'includes/emailer.'.$phpEx); 
             $emailer = new emailer($board_config['smtp_delivery']); 
         } 
 
         $emailer->from($board_config['board_email']); 
         $emailer->replyto($board_config['board_email']); 
 
         $emailer->use_template('privmsg_notify', $to_userdata['user_lang']); 
         $emailer->email_address($to_userdata['user_email']); 
         $emailer->set_subject($lang['Notification_subject']); 
 
         $emailer->assign_vars(array( 
             'USERNAME' => $to_username, 
             'SITENAME' => $board_config['sitename'], 
             'EMAIL_SIG' => (!empty($board_config['board_email_sig'])) ? str_replace('<br />', "\n", "-- \n" . $board_config['board_email_sig']) : '', 
 
             'U_INBOX' => $server_protocol . $server_name . $server_port . $script_name . '?folder=inbox') 
         ); 
 
         $emailer->send(); 
         $emailer->reset(); 
     } 
 
     return; 
 
     $msg = $lang['Message_sent'] . '<br /><br />' . sprintf($lang['Click_return_inbox'], '<a href="' . append_sid("privmsg.$phpEx?folder=inbox") . '">', '</a> ') . '<br /><br />' . sprintf($lang['Click_return_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a>'); 
 
     message_die(GENERAL_MESSAGE, $msg); 
 
 }

class clan
{
	var $data;
	var $clan_id;

	function clan ( )
	{
		global	$db;
		global	$userdata;

		$sql				= 'SELECT * FROM ' . USERS_TABLE . ' WHERE user_id = ' . $userdata[ 'user_id' ];
		$result				= $db->sql_query ( $sql );
		$row				= $db->sql_fetchrow ( $result );
		$this->clan_id		= $row[ 'clan_session' ];
		$this->data			= $this->data ( );
	}

	function data ( $grab = '', $clan_id = '' )
	{
		global	$db;

		$type	= ( !empty ( $clan_id ) ) ? $clan_id : $this->clan_id;
		$sql	= 'SELECT * FROM ' . CLANS_TABLE . ' WHERE clan_id = ' . $type;
		$result	= $db->sql_query ( $sql );
		$row	= $db->sql_fetchrow ( $result );

		return ( !empty ( $grab ) ) ? $row[ $grab ] : $row;
	}
}

class tournament
{
	var $data;
	var $rounds_widths;
	var $rounds_list;
	var $rounds_array;

	function tournament ( )
	{
		$this->data	= $this->data ( );
	}

	function data ( $grab = '', $tournament_id = '' )
	{
		global	$db;
		global	$http_vars;

		$type	= ( !empty ( $tournament_id ) ) ? $tournament_id : $http_vars[ 'tournament_id' ];
		$sql	= 'SELECT * FROM ' . TOURNAMENTS_TABLE . ' WHERE tournament_id = ' . $type;
		$result	= $db->sql_query ( $sql );
		$row	= $db->sql_fetchrow ( $result );

		return ( !empty ( $grab ) ) ? $row[ $grab ] : $row;
	}

	function pass_on ( $feed )
	{
		global	$db;
		global	$lang;
		global	$clan;

		$i		= 0;
		foreach ( explode ( '|', $this->data[ $feed ] ) AS $sections )
		{
			preg_match_all ( '#(.*):(.*)_(.*)#', $sections, $result );
			$data_2[ $result[ 2 ][ 0 ] ][ $i ]	= array (
				'CLAN_ID' => $result[ 1 ][ 0 ],
				'BRACKET' => $result[ 2 ][ 0 ],
				'POS' => $result[ 3 ][ 0 ]
			);
			$i++;
		}

		$data_2	= array_reverse ( $data_2 );
		foreach ( $data_2 AS $bracket )
		{
			foreach ( $bracket AS $clan_array )
			{
				if ( $clan_array[ 'CLAN_ID' ] == $clan->data[ 'clan_id' ] )
				{
					$clan_groups[ ]	= $bracket;
					break ( 2 );
				}
			}
		}

		foreach ( $clan_groups AS $clans )
		{
			foreach ( $clans AS $eclan )
			{
				$other_clans	+= 1;
			}
		}

		foreach ( $clan_groups AS $clans )
		{
			foreach ( $clans AS $eclan )
			{
				if ( $eclan[ 'CLAN_ID' ] == $clan->data[ 'clan_id' ] )
				{
					$found	= $eclan;
					break ( 2 );
				}
			}
		}

		$cheating	= ( $other_clans % 2 == 0 ) ? true : false;
		if ( $cheating == true )
		{
			return true;
		}
		else
		{
			$new_bracket	= $found[ 'BRACKET' ][ 'BRACKET' ] + 1;
			$new_pos		= round ( $found[ 'POS' ] / 2 );
			$feed_new		.= $this->data[ $feed ] . '|' . $clan->data[ 'clan_id' ] . ':' . $new_bracket . '_' . $new_pos;

			$sql	= 'UPDATE ' . TOURNAMENTS_TABLE . ' SET ' . $feed . ' = "' . $feed_new . '" WHERE tournament_id = ' . $this->data[ 'tournament_id' ];
			$db->sql_query ( $sql );

			// Not cheating! ... Let the clan advance!
			message_die ( GENERAL_MESSAGE, $lang[ 'rivals_78cn' ] );
		}
	}

	function generate_brackets ( $double_elimination = '' )
	{
		global	$lang;

		$brackets			= ( !empty ( $double_elimination ) ) ? $this->data[ 'tournament_brackets' ] - 1 : $this->data[ 'tournament_brackets' ];
		$spots				= ( $brackets * 2 - 1 );
		$temp_rows			= $brackets;
		$rounds_widths		= array ( );

		while ( $temp_rows > 1 )
		{
			$row_count++;

			if ( $row_count > 1 )
			{
				$temp_rows	= ( $temp_rows / 2 );
			}

			$rows	= $row_count;
		}

		$row_widths	= round ( 100 / $rows - 0.5 );
		$counter	= $brackets;

		while ( $counter > 1 )
		{
			if ( !empty ( $round ) )
			{
				$counter	= ( $counter / 2 );
			}

			$round++;
			$last_cb			= $count_brackets;
			$count_brackets		= '';
			$game				= '';
			$finals				= ( $rows - 1 );
			$winner				= ( $rows );
			$round_games		= sprintf ( $lang[ 'rivals_tourr' ], $round );

			if ( $round == $winner)
			{
				$round_games	= $lang[ 'rivals_tourw' ];
			}
			else if ( $round == $finals )
			{
				$round_games	= $lang[ 'rivals_tourf' ];
			}

			$rounds_widths[ $round_games ]		= $row_widths;
			$rounds_list[ ]						= $round_games;
			$rounds_array[ $round_games ]		= array ( );

			$space_setcount	= '';
			while ( $count_brackets < $counter )
			{
				$count_brackets++;
				$spot++;
				$space_setcount++;

				if ( $space_setcount == '4' )
				{
					$space_setcount	= '';
				}

				$bracket_id							= $round . '_' . $count_brackets;
				$rounds_array[ $round_games ][ ]	= array ( $bracket_id );

				if ( $count_brackets < $counter )
				{
					$space_counter++;
					$space_counter	= ( $space_counter + 1 );

					if ( $space_counter == '2' )
					{
						$roundx2p1	= ( $last_roundx2p1 * 2 + 1 );
						if ( $round == '1' )
						{
							$roundx2p1	= 1;
						}

						while ( $count_spaces < $roundx2p1 )
						{
							$count_spaces++;
 
							$space_centercount++;
 							$space_centerword	= '';
							$spacecentercountcheck	= ( $last_roundx2p1 + 1 );
 
							if ( $space_centercount == $spacecentercountcheck )
							{
 								$space_centerwordcount++;
								if ( ( $space_centerwordcount == '1' ) || ( $space_centerwordcount == '3' ) )
								{
									$actual_gamecount++;
									$space_centerword	= sprintf ( $lang[ 'rivals_toura' ], $actual_gamecount );

									if ( $space_centerwordcount == 3 )
									{
										$space_centerwordcount	= '';
										$space_centerwordcount++;
									}
								}
							}

							$rounds_array[ $round_games ][ ]	= array ( $space_centerword );
						}

						$space_counter		= '';
						$count_spaces		= '';
						$space_centercount	= '';
					}
				}
			}

			$space_centerwordcount		= '';
			$actual_gamecount			= '';
			$last_roundx2p1				= $roundx2p1;
		}

		$this->rounds_widths	= $rounds_widths;
		$this->rounds_list		= $rounds_list;
		$this->rounds_array		= $rounds_array;
	}

	function generate_tournament ( )
	{
		global	$db;
		global	$lang;
		global	$clan;
		global	$template;

		$this->generate_brackets ( );

		if ( $this->data[ 'tournament_type' ] == 1 )
		{

			$i	= 0;
			$clans2	= array ( );

			foreach ( explode ( '|', $this->data[ 'tournament_clans' ] ) AS $clans )
			{
				$stage	= explode ( ':', $clans );
				foreach ( $stage AS $eclan )
				{
					$clans2[ $stage[ 1 ] ]	= $clan->data ( 'clan_name', $stage[ 0 ] );
				}
			}

			$in_bracket	= array ( );
			foreach ( $this->rounds_array AS $round )
			{
				$template->assign_block_vars ( 'block_rounds', array (
					'S_ROUNDWIDTH' => $this->rounds_array[ $rounds_list[ $i ] ],
					'S_ROUND' => $this->rounds_list[ $i ] )
				);

				foreach ( $round AS $ids )
				{
					if ( empty ( $ids[ 0 ] ) || strstr ( $ids[ 0 ], 'Game' ) )
					{
						$template->assign_block_vars ( 'block_rounds.block_data', array (
							'S_DATA' => '<i>' . $ids[ 0 ] . '</i>',
							'S_COLOR' => 'row1' )
						);
					}
					else
					{
						$template->assign_block_vars ( 'block_rounds.block_data', array (
							'S_DATA' => '<b>' . $clans2[ $ids[ 0 ] ] . '</b>',
							'S_COLOR' => 'row2' )
						);
					}
				}
				$i++;
			}
		}
		else
		{
			$i	= 0;
			$clans2	= array ( );

			foreach ( explode ( '|', $this->data[ 'tournament_clans' ] ) AS $clans )
			{
				$stage	= explode ( ':', $clans );
				foreach ( $stage AS $eclan )
				{
					$clans2[ $stage[ 1 ] ]	= $clan->data ( 'clan_name', $stage[ 0 ] );
				}
			}

			$in_bracket	= array ( );
			foreach ( $this->rounds_array AS $round )
			{
				$template->assign_block_vars ( 'block_rounds', array (
					'S_ROUNDWIDTH' => $this->rounds_widths[ $this->rounds_list[ $i ] ],
					'S_ROUND' => $this->rounds_list[ $i ] )
				);

				foreach ( $round AS $ids )
				{
					if ( empty ( $ids[ 0 ] ) || strstr ( $ids[ 0 ], 'Game' ) )
					{
						$template->assign_block_vars ( 'block_rounds.block_data', array (
							'S_DATA' => '<i>' . $ids[ 0 ] . '</i>',
							'S_COLOR' => 'row1' )
						);
					}
					else
					{
						$template->assign_block_vars ( 'block_rounds.block_data', array (
							'S_DATA' => '<b>' . $clans2[ $ids[ 0 ] ] . '</b>',
							'S_COLOR' => 'row2' )
						);
					}
				}
				$i++;
			}

			$this->generate_brackets ( true );

			$this->rounds_widths		= array_reverse ( $this->rounds_widths );
			$this->rounds_list			= array_reverse ( $this->rounds_list );
			$this->rounds_array			= array_reverse ( $this->rounds_array );

			$i	= 0;
			$clans2	= array ( );

			foreach ( explode ( '|', $this->data[ 'tournament_clans2' ] ) AS $clans )
			{
				$stage	= explode ( ':', $clans );
				foreach ( $stage AS $eclan )
				{
					$clans2[ $stage[ 1 ] ]	= $clan->data ( 'clan_name', $stage[ 0 ] );
				}
			}
			$clans2	= array_reverse ( $clans2 );

			$in_bracket	= array ( );
			foreach ( $this->rounds_array AS $round )
			{
				$template->assign_block_vars ( 'block_rounds2', array (
					'S_ROUNDWIDTH' => $this->rounds_widths[ $this->rounds_list[ $i ] ],
					'S_ROUND' => $this->rounds_list[ $i ] )
				);

				foreach ( $round AS $ids )
				{
					if ( empty ( $ids[ 0 ] ) || strstr ( $ids[ 0 ], 'Game' ) )
					{
						$template->assign_block_vars ( 'block_rounds2.block_data2', array (
							'S_DATA' => '<i>' . $ids[ 0 ] . '</i>',
							'S_COLOR' => 'row1' )
						);
					}
					else
					{
						$template->assign_block_vars ( 'block_rounds2.block_data2', array (
							'S_DATA' => '<b>' . $clans2[ $ids[ 0 ] ] . '</b>',
							'S_COLOR' => 'row2' )
						);
					}
				}
				$i++;
			}

			$dblw	= ( !empty ( $this->data[ 'tournament_dblw' ] ) ) ? $clan->data ( 'clan_name', $this->data[ 'tournament_dblw' ] ) : 'N/A';
			$dbllw	= ( !empty ( $this->data[ 'tournament_dbllw' ] ) ) ? $clan->data ( 'clan_name', $this->data[ 'tournament_dbllw' ] ) : 'N/A';
			$winner	= ( !empty ( $this->data[ 'tournament_winner' ] ) ) ? $clan->data ( 'clan_name', $this->data[ 'tournament_winner' ] ) : 'N/A';

			$template->assign_block_vars ( 'block_winners', array (
				'S_DBLW' => $dblw,
				'S_DBLLW' => $dbllw,
				'S_WINNER' => $winner,
				'L_RESULTS' => $lang[ 'rivals_186' ] )
			);

			$template->assign_vars ( array (
				'S_WINNERBRACKET' => $lang[ 'rivals_iwiom' ],
				'S_LOOSERBRACKET' => $lang[ 'rivals_iwiop' ] )
			);
		}
	}
}

class ladder
{
	var $data;

	function ladder ( )
	{
		$this->data	= $this->data ( );
	}

	function data ( $grab = '', $ladder_id = '' )
	{
		global	$db;
		global	$http_vars;

		$type		= ( !empty ( $ladder_id ) ) ? $ladder_id : $http_vars[ 'ladder_id' ];
		$sql		= 'SELECT * FROM ' . LADDERS_TABLE . ' WHERE ladder_id = ' . $type;
		$result	= $db->sql_query ( $sql );
		$row		= $db->sql_fetchrow ( $result );

		return ( !empty ( $grab ) ) ? $row[ $grab ] : $row;
	}
}

?>
