/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import javax.swing.JComponent;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.DeviceConnectListener;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;
import org.nongnu.pulsefire.wire.WirePulseMode;

public class JComponentEnableStateListener
implements DeviceConnectListener,
DeviceCommandListener {
    private JComponent component = null;
    private CommandName commandName = null;

    public JComponentEnableStateListener(JComponent component, CommandName commandVariableFilter) {
        this.commandName = commandVariableFilter;
        this.component = component;
        this.component.setEnabled(false);
        PulseFireUI.getInstance().getDeviceManager().addDeviceConnectListener((DeviceConnectListener)this);
    }

    public static void attach(JComponent component, CommandName commandVariableFilter) {
        new JComponentEnableStateListener(component, commandVariableFilter);
    }

    public void deviceConnect() {
        if (this.commandName == null) {
            this.component.setEnabled(true);
            return;
        }
        if (this.commandName.isDisabled()) {
            return;
        }
        if (this.commandName.getChipFlagDependency() != null) {
            Command cmd = PulseFireUI.getInstance().getDeviceData().getDeviceParameter(CommandName.chip_flags);
            if (!this.commandName.getChipFlagDependency().isFlagActive(cmd)) {
                return;
            }
        }
        if (this.commandName.isPulseModeDependency()) {
            PulseFireUI.getInstance().getDeviceManager().addDeviceCommandListener(CommandName.pulse_mode, (DeviceCommandListener)this);
            this.commandReceived(PulseFireUI.getInstance().getDeviceData().getDeviceParameter(CommandName.pulse_mode));
        } else {
            this.component.setEnabled(true);
        }
    }

    public void deviceDisconnect() {
        this.component.setEnabled(false);
    }

    public void commandReceived(Command command) {
        Integer mode = new Integer(command.getArgu0());
        for (int i = 0; i < WirePulseMode.values().length; ++i) {
            if (!mode.equals(i)) continue;
            WirePulseMode pulseMode = WirePulseMode.values()[i];
            this.checkMode(pulseMode);
            break;
        }
    }

    private void checkMode(WirePulseMode newMode) {
        if (this.commandName.getPulseModeDependencies() == null) {
            this.component.setEnabled(true);
            return;
        }
        for (WirePulseMode depMode : this.commandName.getPulseModeDependencies()) {
            if (!depMode.equals((Object)newMode)) continue;
            this.component.setEnabled(true);
            return;
        }
        this.component.setEnabled(false);
    }
}

