/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.tabs;

import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;
import org.nongnu.pulsefire.device.ui.components.JCommandButton;
import org.nongnu.pulsefire.device.ui.components.JCommandCheckBox;
import org.nongnu.pulsefire.device.ui.components.JCommandComboBox;
import org.nongnu.pulsefire.device.ui.components.JCommandDial;
import org.nongnu.pulsefire.device.ui.tabs.AbstractTabPanel;
import org.nongnu.pulsefire.wire.CommandName;

public class JTabPanelSystem
extends AbstractTabPanel {
    private static final long serialVersionUID = -5523263800067726564L;

    public JTabPanelSystem() {
        this.setLayout(new FlowLayout(0));
        JPanel wrap = new JPanel();
        wrap.setLayout(new SpringLayout());
        wrap.add(this.createSystemConfig());
        wrap.add(this.createSystemIO());
        wrap.add(this.createSystemWarmup());
        SpringLayoutGrid.makeCompactGrid(wrap, 1, 3);
        this.add(wrap);
    }

    private JPanel createSystemConfig() {
        JPanel wrapPanel = JComponentFactory.createJFirePanel("Config");
        JPanel confPanel = new JPanel();
        confPanel.setLayout(new SpringLayout());
        confPanel.add(JComponentFactory.createJLabel("Save Config"));
        confPanel.add(new JCommandButton("Save", CommandName.save));
        confPanel.add(JComponentFactory.createJLabel("Reset Config"));
        confPanel.add(new JCommandButton("Reset", CommandName.reset_conf));
        confPanel.add(JComponentFactory.createJLabel("Reset Data"));
        confPanel.add(new JCommandButton("Reset", CommandName.reset_data));
        confPanel.add(JComponentFactory.createJLabel("Reset Chip"));
        confPanel.add(new JCommandButton("Reset", CommandName.reset_chip));
        JButton loadButton = new JButton("Load");
        loadButton.setEnabled(false);
        confPanel.add(JComponentFactory.createJLabel("Load File"));
        confPanel.add(loadButton);
        JButton saveButton = new JButton("Save");
        saveButton.setEnabled(false);
        confPanel.add(JComponentFactory.createJLabel("Save File"));
        confPanel.add(saveButton);
        SpringLayoutGrid.makeCompactGrid(confPanel, 6, 2);
        wrapPanel.add(confPanel);
        return wrapPanel;
    }

    private JPanel createSystemIO() {
        JPanel wrapPanel = JComponentFactory.createJFirePanel("IO");
        JPanel ioPanel = new JPanel();
        ioPanel.setLayout(new SpringLayout());
        ioPanel.add(JComponentFactory.createJLabel("Output Enable"));
        ioPanel.add(new JCommandCheckBox(CommandName.pulse_enable));
        ioPanel.add(JComponentFactory.createJLabel("Output Invert"));
        ioPanel.add(new JCommandCheckBox(CommandName.pulse_inv));
        ioPanel.add(JComponentFactory.createJLabel("Output Steps"));
        ioPanel.add(new JCommandComboBox(CommandName.pulse_steps));
        ioPanel.add(JComponentFactory.createJLabel("Lcd Size"));
        ioPanel.add(new JCommandComboBox(CommandName.lcd_size));
        ioPanel.add(JComponentFactory.createJLabel("Dev volt dot"));
        ioPanel.add(new JCommandComboBox(CommandName.dev_volt_dot));
        ioPanel.add(JComponentFactory.createJLabel("Dev amp dot"));
        ioPanel.add(new JCommandComboBox(CommandName.dev_amp_dot));
        ioPanel.add(JComponentFactory.createJLabel("Dev temp dot"));
        ioPanel.add(new JCommandComboBox(CommandName.dev_temp_dot));
        SpringLayoutGrid.makeCompactGrid(ioPanel, 7, 2);
        wrapPanel.add(ioPanel);
        return wrapPanel;
    }

    private JPanel createSystemWarmup() {
        JPanel wrapPanel = JComponentFactory.createJFirePanel("Warmup");
        wrapPanel.setLayout(new BoxLayout(wrapPanel, 3));
        JPanel warmDialPanel = new JPanel();
        warmDialPanel.setLayout(new FlowLayout(0));
        warmDialPanel.add(JComponentFactory.createJPanelJWrap(new JCommandDial(CommandName.swc_delay)));
        warmDialPanel.add(JComponentFactory.createJPanelJWrap(new JCommandDial(CommandName.swc_secs)));
        warmDialPanel.add(JComponentFactory.createJPanelJWrap(new JCommandDial(CommandName.swc_duty)));
        wrapPanel.add(warmDialPanel);
        JPanel warmPanel = new JPanel();
        warmPanel.setLayout(new SpringLayout());
        warmPanel.add(JComponentFactory.createJLabel("Warmup Mode"));
        warmPanel.add(JComponentFactory.createJPanelJWrap(new JCommandComboBox(CommandName.swc_mode)));
        warmPanel.add(JComponentFactory.createJLabel("Warmup Trigger"));
        warmPanel.add(JComponentFactory.createJPanelJWrap(new JCommandComboBox(CommandName.swc_trig)));
        SpringLayoutGrid.makeCompactGrid(warmPanel, 2, 2);
        wrapPanel.add(warmPanel);
        return wrapPanel;
    }

    @Override
    public Class<?> getTabClassName() {
        return this.getClass();
    }
}

