/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import javax.swing.JComponent;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.DeviceConnectListener;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;
import org.nongnu.pulsefire.wire.WirePulseMode;

public class JComponentEnableStateListener
implements DeviceConnectListener,
DeviceCommandListener {
    private JComponent component = null;
    private CommandName commandName = null;
    private Integer index = null;

    public JComponentEnableStateListener(JComponent component, CommandName commandVariableFilter, Integer index) {
        this.commandName = commandVariableFilter;
        this.component = component;
        this.index = index;
        this.component.setEnabled(false);
        PulseFireUI.getInstance().getDeviceManager().addDeviceConnectListener((DeviceConnectListener)this);
    }

    public static void attach(JComponent component) {
        JComponentEnableStateListener.attach(component, null);
    }

    public static void attach(JComponent component, CommandName commandVariableFilter) {
        JComponentEnableStateListener.attach(component, commandVariableFilter, null);
    }

    public static void attach(JComponent component, CommandName commandVariableFilter, Integer index) {
        new JComponentEnableStateListener(component, commandVariableFilter, index);
    }

    public void deviceConnect() {
        this.checkAll();
        if (this.commandName != null && this.commandName.isPulseModeDependency()) {
            PulseFireUI.getInstance().getDeviceManager().addDeviceCommandListener(CommandName.pulse_mode, (DeviceCommandListener)this);
        }
        if (this.commandName != null && this.commandName.name().endsWith("_a")) {
            PulseFireUI.getInstance().getDeviceManager().addDeviceCommandListener(CommandName.pulse_bank, (DeviceCommandListener)this);
        }
        if (this.commandName != null && this.commandName.name().endsWith("_b")) {
            PulseFireUI.getInstance().getDeviceManager().addDeviceCommandListener(CommandName.pulse_bank, (DeviceCommandListener)this);
        }
        if (this.commandName != null && this.commandName.name().startsWith("req_pulse")) {
            PulseFireUI.getInstance().getDeviceManager().addDeviceCommandListener(CommandName.pulse_trig, (DeviceCommandListener)this);
        }
    }

    public void deviceDisconnect() {
        this.component.setEnabled(false);
        if (this.commandName != null && this.commandName.isPulseModeDependency()) {
            PulseFireUI.getInstance().getDeviceManager().removeDeviceCommandListener(CommandName.pulse_mode, (DeviceCommandListener)this);
        }
        if (this.commandName != null && this.commandName.name().endsWith("_a")) {
            PulseFireUI.getInstance().getDeviceManager().removeDeviceCommandListener(CommandName.pulse_bank, (DeviceCommandListener)this);
        }
        if (this.commandName != null && this.commandName.name().endsWith("_b")) {
            PulseFireUI.getInstance().getDeviceManager().removeDeviceCommandListener(CommandName.pulse_bank, (DeviceCommandListener)this);
        }
        if (this.commandName != null && this.commandName.name().startsWith("req_pulse")) {
            PulseFireUI.getInstance().getDeviceManager().removeDeviceCommandListener(CommandName.pulse_trig, (DeviceCommandListener)this);
        }
    }

    public void commandReceived(Command command) {
        this.checkAll();
    }

    private void checkAll() {
        if (this.commandName == null) {
            this.component.setEnabled(true);
            return;
        }
        if (this.commandName.isDisabled()) {
            this.component.setEnabled(false);
            return;
        }
        if (!this.checkChipFlag()) {
            this.component.setEnabled(false);
            return;
        }
        if (!this.checkPulseMode()) {
            this.component.setEnabled(false);
            return;
        }
        if (!this.checkPulseTrigger()) {
            this.component.setEnabled(false);
            return;
        }
        if (!this.checkPulseBank()) {
            this.component.setEnabled(false);
            return;
        }
        this.component.setEnabled(true);
    }

    private boolean checkChipFlag() {
        if (this.commandName != null && this.commandName.getChipFlagDependency() != null) {
            Command cmd = PulseFireUI.getInstance().getDeviceData().getDeviceParameter(CommandName.chip_flags);
            if (!this.commandName.getChipFlagDependency().isFlagActive(cmd)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkPulseBank() {
        if (this.commandName != null && (this.commandName.name().endsWith("_a") || this.commandName.name().endsWith("_b"))) {
            Command command = PulseFireUI.getInstance().getDeviceData().getDeviceParameter(CommandName.pulse_bank);
            if (command == null) {
                return true;
            }
            if (this.commandName.name().endsWith("_a")) {
                return "0".equals(command.getArgu0());
            }
            return "1".equals(command.getArgu0());
        }
        return true;
    }

    private boolean checkPulseMode() {
        Command command = PulseFireUI.getInstance().getDeviceData().getDeviceParameter(CommandName.pulse_mode);
        if (command == null) {
            return true;
        }
        Integer mode = new Integer(command.getArgu0());
        WirePulseMode[] modes = WirePulseMode.values();
        for (int i = 0; i < modes.length; ++i) {
            if (!mode.equals(i)) continue;
            WirePulseMode pulseMode = modes[i];
            return this.checkPulseModeWire(pulseMode);
        }
        return true;
    }

    private boolean checkPulseModeWire(WirePulseMode newMode) {
        if (this.commandName == null) {
            return true;
        }
        if (this.index != null && (WirePulseMode.FLASH_ZERO == newMode || WirePulseMode.PPM_ALL == newMode)) {
            if (WirePulseMode.PPM_ALL == newMode && this.index > 0 && this.commandName.name().startsWith("ppm_data")) {
                return true;
            }
            if (CommandName.pwm_tune_cnt == this.commandName && this.index > 0) {
                return false;
            }
            if (this.commandName.name().endsWith("_a") && this.index > 0) {
                return false;
            }
            if (this.commandName.name().endsWith("_b") && this.index > 0) {
                return false;
            }
        }
        if (this.commandName.getPulseModeDependencies() == null) {
            return true;
        }
        for (WirePulseMode depMode : this.commandName.getPulseModeDependencies()) {
            if (!depMode.equals((Object)newMode)) continue;
            return true;
        }
        return false;
    }

    private boolean checkPulseTrigger() {
        if (this.commandName == null) {
            return true;
        }
        return true;
    }
}

